/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.report.xml;

import de.kobv.mable.mab2.modules.FieldStatistics;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;

/**
 * Generates an XML field statistics report.
 *
 * This class generates a XML file containing the field statistics for a MAB2
 * file. The report takes an input object (?) and produces a file. A result
 * object (?) might point to the file, so it can be picked up by additional
 * modules for further processing.
 *
 * <mable-fields-statistic>
 *   <field category="001" count="898" />
 *   <field category="025"  >
 *     <a>898</a>
 *     <z>232</z>
 *   </field>
 * </mable-fields-statistic>
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class XmlFieldStatisticsReport {

    /**
     * TODO where does the file come from?
     */
    private File file;

    /**
     * TODO when is this set?
     */
    private FieldStatistics fieldStatistics;

    /**
     * Generates the field statistics XML report.
     *
     * TODO when is this executed? What triggers the execution?
     */
    public void run() {
        Map<String, Integer> fieldsCount = fieldStatistics.getFieldCount();

        try {
            PrintWriter out = new PrintWriter(new FileWriter(file));

            out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            out.println("<mable-fields-statistics>");

            for (Map.Entry<String, Integer> entry : fieldsCount.entrySet()) {
                out.format("  <field id=\"%1$s\" count=\"%2$d\" />",
                        entry.getKey(), entry.getValue());
            }

            out.println("</mable-fields-statistics>");
        }
        catch (IOException ioe) {
            // TODO handle exception
        }
    }

    public FieldStatistics getFieldStatistics() {
        return fieldStatistics;
    }

    public void setFieldStatistics(FieldStatistics fieldStatistics) {
        this.fieldStatistics = fieldStatistics;
    }

}
