/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.report.text;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.reports.Report;
import de.kobv.mable.reports.ReportModule;
import de.kobv.mable.reports.log4j.Log4jReportWriterFactory;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class TextSummaryReport implements Report {

    private List<ReportModule> reports;

    private Logger logger;

    @Override
    public void generate() {
        Log4jReportWriterFactory reportFactory = new Log4jReportWriterFactory();
        String name = ( String )MableProperties.getProperty("filename");
        String logTimestamp = ( String )MableProperties.getProperty("timestampString");
        try {
            logger = reportFactory.getReportWriter(name, "report", logTimestamp, "_Mable-report.txt");
        }
        catch (IOException ioe) {
            // TODO do something
        }

        logger.info("Mable-Report zu MAB-Datei " + name);

        Integer datasetsFound = ( Integer )MableProperties.getProperty("datasetsProcessed");
        Integer datasetsIgnored = ( Integer )MableProperties.getProperty("datasetsIgnored");

        logger.info("\n" + datasetsFound + " Sätze gefunden.\n"
            + datasetsIgnored + " Sätze wurden ignoriert und nicht mitgezählt, da z.B. die Satzkennung nicht zu " +
                "parsen war.\n"
                + "Darüber hinaus können einzelne Felder oder Unterfelder ingoriert worden sein. Siehe " +
                "Reject-Datei.\n");

        for (ReportModule report : reports) {
            report.setReport(logger);
            report.generate();
        }
    }

    @Override
    public void setReport(Logger logger) {
        this.logger = logger;
    }

    public void setReports(List<ReportModule> reports) {
        this.reports = reports;
    }

}
