/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.report.chart;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.ArrayList;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class PieChart {

    private int width;

    private int height;

    private String cssClass;

    private String cssId;

    private List<PieSlice> slices = new ArrayList<PieSlice>();

    public PieChart(int width, int height) {
        this.width = width + 80;
        this.height = height;
    }

    public PieSlice createSlice(double value) {
        return null;
    }

    public void addSlice(PieSlice slice) {
        slices.add(slice);
    }

    public void renderAsSvg(OutputStream out) {
        PrintWriter pout = new PrintWriter(new OutputStreamWriter(out));

        pout.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\" ?>");
        pout.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20010904//EN\"");
        pout.println("\"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">");

        pout.println("<svg width=\"" + width + "\" height=\"" + height + "\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");

        pout.println("<title>Ergebnis</title>");
        pout.println("<desc>Ergebnisübersicht</desc>");

        // add all values to get total
        float total = 0;

        for (PieSlice slice : slices) {
            total += slice.getValue();
        }

        int centerX = (width - 80) / 2 + 80;
        int centerY = height / 2;

        int radius = 100;

        double sx = centerX;

        double sy = centerY - radius;

        double totalAngle = 0;

        int index = 0;

        for (PieSlice slice : slices) {

            float value = slice.getValue();

            double angle = (value / total) * 360;

            totalAngle += angle;

            double angleRad = totalAngle * 2 * Math.PI / 360;

            double dx = Math.sin(angleRad) * radius;
            double dy = Math.cos(angleRad) * radius;

            double x = Math.round(dx) + centerX;
            double y = centerY - Math.round(dy);

            /* TODO convert into DEBUG output
            System.out.println("     value = " + value);
            System.out.println("         x = " + x);
            System.out.println("         y = " + y);
            System.out.println("        dx = " + dx);
            System.out.println("        dy = " + dy);
            System.out.println("     angle = " + angle);
            System.out.println("  angleRad = " + angleRad);
            System.out.println("totalAngle = " + totalAngle);
             */

            String flags = (angle > 180 ) ? "1,1" : "0,1";

            pout.println("<path d=\"M" + centerX + "," + centerY + " L" + Math.round(sx) + "," + Math.round(sy)
                + " A100,100 0 " + flags + " " + Math.round(x) + "," + Math.round(y) + " z\"");
            pout.println("style=\"fill:" + slice.getColor() + ";");
            pout.println("fill-opacity: 1;");
            pout.println("stroke: " + slice.getStroke() + ";");
            pout.println("stroke-width: 1\""
                + "/>");

            sx = x;
            sy = y;

            pout.println(String.format("<rect x=\"%1$d\" y=\"%2$d\" width=\"%3$d\" height=\"%4$d\" style=\"fill: %5$s\" />", 10, 10 + index * 20, 10, 10, slice.getColor()));
            pout.println(String.format("<text x=\"%1$d\" y=\"%2$d\" font-size=\"12pt\">%3$s</text>", 30, 20 + index * 20, slice.getLabel()));

            index++;
        }

        pout.println("</svg>");

        pout.close();
    }

}
