/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.extension.ErrorType;
import org.junit.Test;

import java.util.HashSet;
import java.util.Set;

import static org.junit.Assert.*;

/**
 * Unit Tests for RequiredCategoryErrorType class.
 */
public class RequiredCategoryErrorTypeTest {

    @Test
    public void testCreateError() {
        RequiredCategoryErrorType error = new RequiredCategoryErrorType("001");
        assertEquals("001", error.getCategory());
    }

    @Test
    public void testStoreInSetByType() {
        Set<ErrorType> errors = new HashSet<ErrorType>();

        errors.add(new RequiredCategoryErrorType("001"));
        errors.add(new RequiredCategoryErrorType("001"));

        assertEquals(1, errors.size());
    }

    @Test
    public void testStoreInSet() {
        Set<ErrorType> errors = new HashSet<ErrorType>();

        errors.add(new RequiredCategoryErrorType("001"));
        errors.add(new RequiredCategoryErrorType("002"));

        assertEquals(2, errors.size());
    }

    @Test
    public void testEqualsFalse() {
        RequiredCategoryErrorType error1 = new RequiredCategoryErrorType("001");
        RequiredCategoryErrorType error2 = new RequiredCategoryErrorType("026");

        assertFalse(error1.equals(error2));
        // assertTrue(error1.compareTo(error2) != 0) ;
    }

    @Test
    public void testCompareToEquals() {
        RequiredCategoryErrorType error1 = new RequiredCategoryErrorType("001");
        RequiredCategoryErrorType error2 = new RequiredCategoryErrorType("001");

        assertEquals(error1, error2);
    }

    @Test
    public void testErrorTypeHashesEqual() {
        RequiredCategoryErrorType error1 = new RequiredCategoryErrorType("001");
        RequiredCategoryErrorType error2 = new RequiredCategoryErrorType("001");

        assertEquals(error1.hashCode(), error2.hashCode());
    }

    @Test
    public void testErrorTypeHashesNotEqual() {
        RequiredCategoryErrorType error1 = new RequiredCategoryErrorType("001");
        RequiredCategoryErrorType error2 = new RequiredCategoryErrorType("026");

        assertFalse(error1.hashCode() == error2.hashCode());
    }

    @Test
    public void testErrorTypeNotEqualWithSatztyp() {
        RequiredCategoryErrorType error1 = new RequiredCategoryErrorType("050", "u");
        RequiredCategoryErrorType error2 = new RequiredCategoryErrorType("050", "h");

        assertFalse(error1.equals(error2));
    }

    @Test
    public void testErrorTypeNotEqualsWithSatztypNull() {
        RequiredCategoryErrorType error1 = new RequiredCategoryErrorType("050", null);
        RequiredCategoryErrorType error2 = new RequiredCategoryErrorType("050", "h");

        assertFalse(error1.equals(error2));
    }

    @Test
    public void testGetMessageNotNull() {
        RequiredCategoryErrorType errorType = new RequiredCategoryErrorType("001");

        assertNotNull(errorType.getMessage());
    }

    @Test
    public void testGetMessageEquals() {
        RequiredCategoryErrorType errorType = new RequiredCategoryErrorType("001");

        assertEquals("Satz ohne MAB-Feld 001 (Identifikationsnummer des Datensatzes).", errorType.getMessage());
    }

    @Test
    public void testGetMessageEqualsWithSatztyp() {
        RequiredCategoryErrorType errorType = new RequiredCategoryErrorType("331", "h");

        assertEquals("'h'-Satz ohne MAB-Feld 331 (Hauptsachtitel in Vorlageform oder Mischform).",
                errorType.getMessage());
    }

    @Test
    public void testErrorTypeForAlephFeld() {
        RequiredCategoryErrorType errorType = new RequiredCategoryErrorType("LOW");

        assertEquals("LOW", errorType.getCategory());
        assertEquals("Satz ohne MAB-Feld LOW.", errorType.getMessage());
    }

}
