/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

/**
 * Unit tests for class GkdWithoutName.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class GkdWithoutNameTest {

    private MabSatz satz;

    private MockErrorStatistics errorStatistics;

    private GkdWithoutName module;

    @Before
    public void before() {
        satz = new MabSatz("01024nM2.01200024      h");
        errorStatistics = new MockErrorStatistics();
        module = new GkdWithoutName();
        module.setErrorStatistics(errorStatistics);
    }


    @Test
    public void testGkdButNoNameFound() {
        satz.addFeld(new MabFeld(202, ' ', "gkd"));

        module.process(satz);

        assertEquals(1, errorStatistics.getErrors().size());
        assertTrue(errorStatistics.getErrors().get(0) instanceof DatasetError);
        assertTrue(errorStatistics.getErrors().get(0).getErrorType() instanceof GkdWithoutNameErrorType);
    }

    @Test
    public void testNameButNoGkdFound() {
        satz.addFeld(new MabFeld(200, ' ', "name"));

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testNameAndGkdFound() {
        satz.addFeld(new MabFeld(200, ' ', "name"));
        satz.addFeld(new MabFeld(202, ' ', "gkd"));

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testNoNameOrGkd() {
        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testZweiteGkdWithoutName() {
        satz.addFeld(new MabFeld(206, ' ', "gkd"));

        module.process(satz);

        assertEquals(1, errorStatistics.getErrors().size());
        assertTrue(errorStatistics.getErrors().get(0) instanceof DatasetError);
        assertTrue(errorStatistics.getErrors().get(0).getErrorType() instanceof GkdWithoutNameErrorType);
    }

    @Test
    public void testLetzteGkdWithoutName() {
        satz.addFeld(new MabFeld(298, ' ', "gkd"));

        module.process(satz);

        assertEquals(1, errorStatistics.getErrors().size());
        assertTrue(errorStatistics.getErrors().get(0) instanceof DatasetError);
        assertTrue(errorStatistics.getErrors().get(0).getErrorType() instanceof GkdWithoutNameErrorType);
    }

    @Test
    public void testLetzteGkdWithName() {
        satz.addFeld(new MabFeld(296, ' ', "name"));
        satz.addFeld(new MabFeld(298, ' ', "gkd"));

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

}
