/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import java.util.Map;

import static org.junit.Assert.*;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class FieldStatisticsTest {

    private FieldStatistics fields;

    @Before
    public void before() {
        fields = new FieldStatistics();
    }

    @Test
    public void testAddField() {
        assertEquals(0, fields.getFieldCount().size());

        fields.addField("025z");

        Map<String, Integer> fieldsCount = fields.getFieldCount();

        assertEquals(1, fieldsCount.size());

        Integer fieldCount = fieldsCount.get("025z");

        assertNotNull(fieldCount);
        assertEquals(1, fieldCount.intValue());
    }

    @Test
    public void testProcess() {
        MabSatz satz = new MabSatz("01024nM2.01200024      h");
        satz.addFeld(new MabFeld(001, ' '));
        satz.addFeld(new MabFeld(331, ' '));
        satz.addFeld(new MabFeld(540, ' '));
        satz.addFeld(new MabFeld(540, ' '));
        satz.addFeld(new MabFeld(540, 'a'));

        fields.process(satz);

        Map<String, Integer> statistics = fields.getFieldCount();

        assertEquals(4, statistics.keySet().size());
        assertEquals(1, statistics.get("001 ").intValue());
        assertEquals(1, statistics.get("331 ").intValue());
        assertEquals(2, statistics.get("540 ").intValue());
        assertEquals(1, statistics.get("540a").intValue());
    }

}
