/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import org.junit.Test;

import static org.junit.Assert.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/30/12
 * Time: 10:54 AM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class FieldDependencyErrorTypeTest {

    @Test
    public void testConstruct() {
        FieldDependencyErrorType errorType = new FieldDependencyErrorType("300", "100");

        assertEquals("300", errorType.getKategorie1());
        assertEquals("100", errorType.getKategorie2());
    }

    @Test
    public void testGetHash() {
        FieldDependencyErrorType errorType = new FieldDependencyErrorType("300", "100");

        assertTrue(errorType.getHash() != 0);
    }

    @Test
    public void testEqual() {
        FieldDependencyErrorType errorType1 = new FieldDependencyErrorType("300", "100");
        FieldDependencyErrorType errorType2 = new FieldDependencyErrorType("300", "100");

        assertTrue(errorType1.equals(errorType2));
    }

    @Test
    public void testNotEqualKategorie1() {
        FieldDependencyErrorType errorType1 = new FieldDependencyErrorType("300", "100");
        FieldDependencyErrorType errorType2 = new FieldDependencyErrorType("300", "101");

        assertFalse(errorType1.equals(errorType2));

    }

    @Test
    public void testNotEqualKategorie2() {
        FieldDependencyErrorType errorType1 = new FieldDependencyErrorType("300", "100");
        FieldDependencyErrorType errorType2 = new FieldDependencyErrorType("301", "100");

        assertFalse(errorType1.equals(errorType2));
    }

    @Test
    public void testNotEqualCategoriesSwitched() {
        FieldDependencyErrorType errorType1 = new FieldDependencyErrorType("300", "100");
        FieldDependencyErrorType errorType2 = new FieldDependencyErrorType("100", "300");

        assertFalse(errorType1.equals(errorType2));
    }

    @Test
    public void testGetMessageNotNull() {
        FieldDependencyErrorType errorType = new FieldDependencyErrorType("300", "100");

        assertNotNull(errorType.getMessage());
    }

    @Test
    public void testGetMessageEquals() {
        FieldDependencyErrorType errorType = new FieldDependencyErrorType("300", "100");

        assertEquals("Satz mit 300, aber ohne 100.", errorType.getMessage());
    }

}
