/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabFeldDefinition;
import org.junit.Ignore;
import org.junit.Test;

import java.util.EnumSet;

import static org.junit.Assert.assertEquals;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO error messages, codes
 */
public class FieldCountAutoTest {

    @Test
    public void testAutoConfigurationMAB30() throws Exception {
        FieldCountAuto module = new FieldCountAuto();

        module.setFeldnummer(30);
        module.init();

        assertEquals(1, module.getMax());
        assertEquals(1, module.getMin());

        assertEquals("030", module.getKategorie());
    }

    @Test
    public void testAutoConfigurationMAB25z() throws Exception {
        FieldCountAuto module = new FieldCountAuto();

        module.setFeldnummer(25);
        module.setIndikator('z');
        module.init();

        assertEquals(1, module.getMax());
        assertEquals(0, module.getMin());

        module.setIndikator(( char ) 0);
        module.init();

        assertEquals(11, module.getMax());
        assertEquals(0, module.getMin());
    }

    @Test
    public void testAutoConfigurationMAB25zReverseCallOrder() throws Exception {
        FieldCountAuto module = new FieldCountAuto();

        module.setIndikator('z');
        module.setFeldnummer(25);
        module.init();

        assertEquals(1, module.getMax());
        assertEquals(0, module.getMin());
    }

    @Test
    public void testAutoConfigurationMAB25() throws Exception {
        FieldCountAuto module = new FieldCountAuto();

        module.setFeldnummer(25);
        module.init();

        assertEquals(11, module.getMax());
        assertEquals(0, module.getMin());
    }

    @Test
    public void testAutoConfigurationMAB51() throws Exception {
        FieldCountAuto module = new FieldCountAuto();

        module.setFeldnummer(51);
        module.init();

        assertEquals(0, module.getMin());
        assertEquals(1, module.getMax());
    }

    @Test
    @Ignore
    public void testAutoConfigurationNonRepeatableLeaders() {
        for (MabFeldDefinition feld : EnumSet.allOf(MabFeldDefinition.class)) {
            if (!feld.isIndikatorWiederholbar()) {
                FieldCountAuto module = new FieldCountAuto();
                module.setFeldnummer(feld.getFeldnummer());
                assertEquals(1, module.getMax());
                assertEquals(0, module.getMin());
            }
        }
    }

}
