/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabException;
import de.kobv.mable.mab.MabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 * Unit Tests for class BadExtraField.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class BadExtraFieldTest {

    /**
     * Valid MAB dataset header for testing.
     */
    public static final String VALID_KENNUNG = "01024nM2.01200024      h";

    private MabSatz satz;

    private BadExtraField module;

    private MockErrorStatistics errorStatistics;

    @Before
    public void before() {
        satz = new MabSatz(VALID_KENNUNG);
        satz.addFeld(new MabFeld(1, ' ', "ID0001"));
        errorStatistics = new MockErrorStatistics();
        module = new BadExtraField();
        module.setErrorStatistics(errorStatistics);
        module.setSatzTyp('u');
        module.setFeldnummer(310);
    }

    @Test
    public void testFieldNotFound() throws MabException {
        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testFieldNotFoundForDatasetTypeDifferent() {
        module.setSatzTyp('h');
        module.setFeldnummer(90);

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());

    }

    @Test
    public void testFieldFoundButDatasetTypeDifferent() {
        satz.addFeld(new MabFeld(310, ' '));

        module.process(satz);

        assertEquals(0, errorStatistics.getErrors().size());
    }

    @Test
    public void testFieldFoundForMatchingDatasetType() {
        module.setSatzTyp('h');
        module.setFeldnummer(90);

        satz.addFeld(new MabFeld(90, ' '));

        module.process(satz);

        assertEquals(1, errorStatistics.getErrors().size());

        DatasetError error = errorStatistics.getErrors().get(0);

        assertTrue(error instanceof DatasetError);
        assertTrue(error.getErrorType() instanceof BadExtraFieldErrorType);
        assertEquals("ID0001", error.getSatzId());
    }

}
