/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.extension.ErrorType;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Error class for missing MAB2 category.
 *
 * Der Fehler wird für eine fehlende MAB2 Kategorie bzw. eine Kategorie mit einem bestimmten Indikator produziert.
 *
 * TODO Kategorie und Indikator separate speichern
 */
public class RequiredCategoryErrorType extends ErrorType {

    private String category;

    private String satzTyp;

    private int errorHash;

    public RequiredCategoryErrorType(String category) {
        this(category, null, null, 0);
    }

    public RequiredCategoryErrorType(String category, String satzTyp) {
        this(category, satzTyp, null, 0);
    }

    public RequiredCategoryErrorType(String category, String satzTyp, String message, int errorCode) {
        super(message, errorCode);
        this.category = category;
        this.satzTyp = satzTyp;
    }

    public String getCategory() {
        return category;
    }

    public String getSatzTyp() {
        return satzTyp;
    }

    @Override
    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            String feldname = getFeldname(category);
            if (feldname == null) {
                feldname = "";
            }
            else {
                feldname = " (" + feldname + ")";
            }
            if (satzTyp == null) {
                msg = String.format("Satz ohne MAB-Feld %1$s%2$s.", category, feldname);
            }
            else {
                msg = String.format("'%1$s'-Satz ohne MAB-Feld %2$s%3$s.", satzTyp, category, feldname);
            }
        }
        return msg;
    }

    @Override
    public String toString() {
        return super.toString() + "[" + category + "]";
    }

    @Override
    public int getHash() {
        if (errorHash == 0) {
            errorHash = new HashCodeBuilder()
                    .append(this.getClass())
                    .append(satzTyp)
                    .append(getCategory())
                    .toHashCode();
        }
        return errorHash;
    }


}
