/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;

import java.util.List;

/**
 * Registers an error if field A exists and not field B.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class FieldDependency extends AbstractMabCheck {

    /**
     * Category (field) number for second required field.
     */
    private String zweiteKategorie;

    /**
     * Indicator for second field.
     */
    private char zweiterIndikator;

    /**
     * Checks if field matches required ones.
     *
     * TODO indicator could be null?
     */
    @Override
    public void process(final MabSatz satz) {
        List<IMabFeld> felder1 = satz.getFelder(getKategorie(), getIndikator());

        List<IMabFeld> felder2 = satz.getFelder(getZweiteKategorie(), getZweiterIndikator());

        boolean feld1Found = felder1 != null && felder1.size() > 0;
        boolean feld2Found = felder2 != null && felder2.size() > 0;

        if (feld1Found && !feld2Found) {
            getErrorStatistics().addError(new DatasetError(
                    new FieldDependencyErrorType(getKategorie(), getZweiteKategorie()), satz.getId()));
        }
    }

    public String getZweiteKategorie() {
        return zweiteKategorie;
    }

    public void setZweiteKategorie(String zweiteKategorie) {
        this.zweiteKategorie = zweiteKategorie;
    }

    public void setZweiteFeldnummer(int feldnummer) {
        setZweiteKategorie(MabFeldDefinition.getFeldnummerString(feldnummer));
    }

    public char getZweiterIndikator() {
        return zweiterIndikator;
    }

    public void setZweiterIndikator(char zweiterIndikator) {
        this.zweiterIndikator = zweiterIndikator;
    }

}
