/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabFeldDefinition;
import org.apache.log4j.Logger;

/**
 * Prüft die Einhaltung des Wiederholfaktors für ein MAB Feld.
 *
 * Dieses Module wird nur mit der Nummer des MAB Feldes konfiguriert und initialisiert den Maximal- und den Minimalwert
 * automatisch.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO init is not part of new interface yet (not being called)
 * TODO incomplete
 */
public class FieldCountAuto extends FieldCount {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(FieldCountAuto.class);

    /**
     * Initializes configuration for field count check.
     *
     * @throws de.kobv.mable.common.MableConfigurationException
     */
    @Override
    public void init() throws MableConfigurationException {
        String kategorie = getKategorie();
        char indikator = getIndikator();

        int feldnummer = 0;

        try {
            feldnummer = Integer.parseInt(kategorie);
        }
        catch (NumberFormatException nfe) {
            throw new MableConfigurationException("FieldCountAuto kann nur MAB2 Felder prüfen.");
        }

        MabFeldDefinition feld = MabFeldDefinition.getFeld(feldnummer);

        if (feld != null) {
            int min = 0;
            int max = feld.getWiederholfaktor();

            if (feld.isRequired()){
                min = 1;
            }

            if (indikator != 0) {
                char[] indikatoren = feld.getIndikatoren();

                if (indikatoren != null && indikatoren.length > 0) {
                    if (!feld.isIndikatorWiederholbar() && feld.hatIndikator(indikator)) {
                        LOG.debug("Indikator darf nicht wiederholt werden, daher MAX = 1 fuer "
                                + feld.getFeldnummerString() + indikator + ".");
                        max = 1;
                    }
                    else {
                        // TODO think about it
                    }
                }
                else {
                    // Feld erlaubt keine Indikatoren
                }
            }

            super.setMin(min);
            super.setMax(max);
        }
        else {
            throw new MableConfigurationException("Field '" + kategorie + "' nicht gefunden.");
        }
    }

}
