/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;

import java.util.List;

/**
 * Checks occurence of a field in a dataset.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO handle min and max switched
 */
public class FieldCount extends AbstractMabCheck {

    /**
     * Minimum number of occurences of field.
     */
    private int min;

    /**
     * Maximum number of occurences of field.
     */
    private int max;

    /**
     * Number of occurences of field.
     */
    private int fieldCount = 0;

    /**
     * Count occurences if a matching field is found.
     *
     * TODO framework should ensure that field has been found
     */
    @Override
    public void process(final MabSatz satz) {

        List<IMabFeld> felder = satz.getFelder(getKategorie(), getIndikator());

        int fieldCount = 0;

        if (felder != null) {
            fieldCount = felder.size();
        }

        if (min > fieldCount || fieldCount > max) {
            getErrorStatistics().addError(new DatasetError(new FieldCountErrorType(getKategorie()), satz.getId()));
        }
    }

    /**
     * Getter for maximum number of field duplications.
     * @return Configured maximum number of duplications
     */
    public int getMax() {
        return max;
    }

    /**
     * Setter for maximum number of field occurences.
     * @param maxCount Maximum number of occurences for field
     */
    public void setMax(final int maxCount) {
        this.max = maxCount;
    }

    /**
     * Getter for minimum number of field occurences.
     * @return Configured minimum number of occurences
     */
    public int getMin() {
        return min;
    }

    /**
     * Setter for minimum number of field occurences.
     * @param minCount Minimum number of occurences for field
     */
    public void setMin(final int minCount) {
        this.min = minCount;
    }

}
