/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.IMabFeld;
import de.kobv.mable.mab.MabFeldDefinition;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;

import java.util.List;

/**
 * Prüft MAB050 Felder auf Fehler.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class Datentraeger extends AbstractMabCheck {

    @Override
    public void process(MabSatz satz) {
        List<IMabFeld> felder = satz.getFelder(MabFeldDefinition.MAB050);

        // TODO Prüfe Wiederholfaktor oder anderem Modul überlassen?
        if (felder.size() == 1) {
            IMabFeld feld = felder.get(0);

            String content = feld.getInhalt();

            if (content.length() > 14) {
                // TODO Fehler um Informationen anreichern
                getErrorStatistics().addError(new DatasetError(
                        new FieldLengthErrorType(MabFeldDefinition.MAB050.getFeldnummerString()),
                        satz.getId()));
            }

            // TODO prüfe auf Wiedersprüche


        }
    }

}
