/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.handler.ReportWriterFactory;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.MableModule2;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import java.io.IOException;

/**
 * Logs content of datasets without 001 field.
 *
 * Wait for end of dataset and if field hasn't appeared, throw error.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO This separates logging datasets without 001 from registering it as an
 * error. Both are independent modules and this module replicates the check and
 * perform the logging without registering an error. Is there a better way?
 * Could the logger listen to the RequiredField events and trigger the logging
 * of the current dataset if no 001 field is found?
 *
 * TODO Separate formatting of log from this class.
 * TODO get rid of ReportFactory dependency (how to sync timestamp across logs?)
 */
public class DatasetWithoutIdLogger extends AbstractMableModule2 {

    /**
     * Logger for datasets without field 001.
     */
    private Logger logger = null; // Logger.getLogger("nomab001");

    private ReportWriterFactory reportFactory;

    /**
     * Logs content of current dataset if no 001 field was found.
     */
    @Override
    public void process(final MabSatz satz) {
        if (!satz.isFeldPresent("001")) {
            Logger log = getLogger();
            log.info("+---");
            log.info(satz);
            log.info("+---");
        }
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        if (this.logger == null) {
            String name = ( String )MableProperties.getProperty("filename");
            String logTimestamp = ( String )MableProperties.getProperty("timestampString");
            try {
                this.logger = reportFactory.getReportWriter(name, "nomab001", logTimestamp, "_Mable-no001.txt");
            }
            catch (IOException ioe) {
                // TODO do something
            }
            this.logger.info("Mable-Datensätze ohne MAB001");

        }
        return this.logger;
    }

    public ReportWriterFactory getReportFactory() {
        return reportFactory;
    }

    @Autowired
    @Required
    public void setReportFactory(ReportWriterFactory reportFactory) {
        this.reportFactory = reportFactory;
    }

}
