/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2.modules;

import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorType;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/24/12
 * Time: 11:21 AM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class AtLeastOneFieldErrorType extends ErrorType {

    private String kategorieOne;

    private String kategorieTwo;

    private String satzTyp;

    public AtLeastOneFieldErrorType(final String satzTyp, final String kategorie1, final String kategorie2) {
        this(satzTyp, kategorie1, kategorie2, null, 0);
    }

    public AtLeastOneFieldErrorType(final String satzTyp, final String kategorie1, final String kategorie2,
                                    String message, int errorCode) {
        super(message,errorCode);
        this.satzTyp = satzTyp;
        this.kategorieOne = kategorie1;
        this.kategorieTwo = kategorie2;
    }

    public String getMessage() {
        String msg = super.getMessage();
        if (msg == null) {
            if (satzTyp == null) {
                msg = "Felder " + kategorieOne + " und " + kategorieTwo + " fehlen beide.";
            }
            else {
                msg =  "Felder " + kategorieOne + " und " + kategorieTwo + " fehlen beide für " + satzTyp + "-Satz.";
            }
        }

        return msg;
    }

    public String getSatzTyp() {
        return satzTyp;
    }

    public String getKategorieOne() {
        return kategorieOne;
    }

    public String getKategorieTwo() {
        return kategorieTwo;
    }

    public int getHash() {
        return new HashCodeBuilder()
                .append(getClass())
                .append(satzTyp)
                .append(kategorieOne)
                .append(kategorieTwo)
                .toHashCode();
    }

}
