/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab2;

import de.kobv.mable.ErrorCode;
import de.kobv.mable.common.MableProperties;
import de.kobv.mable.handler.ReportWriterFactory;
import de.kobv.mable.mab.extension.ErrorStatistics;
import de.kobv.mable.mab.extension.RejectStatistics;
import de.kobv.mable.mab.parser.ContentHandler;
import de.kobv.mable.mab.parser.ErrorHandler;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

import java.io.IOException;
import java.util.Queue;

/**
 * Handler for errors while parsing MAB data.
 *
 * TODO refactor error type to use ENUM and use common methods
 */
public class DefaultErrorHandler implements ErrorHandler {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(DefaultErrorHandler.class);

    private ErrorStatistics errorStatistics;

    private RejectStatistics rejectStatistics;

    private ContentHandler contentHandler;

    /**
     *
     * @param errorqueue Queue of error codes
     *
     * TODO refactor? remove?
     */
    @Override
    public void insertLieferungsfehler(Queue<ErrorCode> errorqueue) {
        for (ErrorCode error : errorqueue) {
            errorStatistics.addPackageError(error);
        }
    }

    @Override
    public void insertLieferungsfehler(ErrorCode error) {
        errorStatistics.addPackageError(error);
    }

    @Override
    public void insertFeldfehler(String bezeichner, Queue<ErrorCode> errorqueue) {
        for (ErrorCode error : errorqueue) {
            errorStatistics.addFieldError(bezeichner, error);
        }
    }

    @Override
    public void insertFeldfehler(String bezeichner, ErrorCode error) {
        errorStatistics.addFieldError(bezeichner, error);
    }

    @Override
    public void insertSatzfehler(Queue<ErrorCode> errorqueue) {
        for (ErrorCode error : errorqueue) {
            errorStatistics.addFormatError(error);
        }
    }

    @Override
    public void insertSatzfehler(ErrorCode error) {
        errorStatistics.addFormatError(error);
    }

    @Override
    public void insertUnterfeldfehler(Queue<ErrorCode> errorqueue) {
        for (ErrorCode error : errorqueue) {
            errorStatistics.addSubfieldError(error);
        }
    }

    @Override
    public void insertUnterfeldfehler(ErrorCode error) {
        errorStatistics.addSubfieldError(error);
    }

    @Override
    public void rejectDataset(ErrorCode errorCode, String mab001, String content, boolean endOfFile) {
        rejectStatistics.addIgnoredDataset(errorCode, mab001);
    }

    @Override
    public void rejectField(ErrorCode errorCode, String content) {
        rejectStatistics.addIgnoredField(errorCode, content);
    }

    @Override
    public void rejectSubfield(ErrorCode errorCode, String content) {
        rejectStatistics.addIgnoredSubfield(errorCode, content);
    }

    @Override
    public void addRejectError(ErrorCode errorCode) {
    }

    @Override
    public void endReject() {
        String id = getCurrentMAB001();
        if (id != null) {
            // getRejectLogger().warn("Die gemeldeten Fehler bezogen sich auf Satz mit"
            //                    + " Identnummer " + id);
            // TODO " (Systemnr.: " + this.satzID + ").");
        }
        else {
            // getRejectLogger().warn("Die gemeldeten Fehler bezogen sich auf einen"
            //        + " Satz, der kein oder mehr als ein 001-Feld hat.");
            // TODO Er ist in der Datenbank unter der ID " + this.satzID +
            // " gespeichert.");
        }
        // getRejectLogger().warn(StringUtils.rightPad("+", 79, "-") + "+");
    }

    public void setErrorStatistics(final ErrorStatistics statistics) {
        this.errorStatistics = statistics;
    }

    /**
     * TODO implement (How?)
     * @return
     */
    public String getCurrentFieldType() {
        return null;
    }

    /**
     * TODO implement (How?)
     * @return
     */
    public String getCurrentMAB001() {
        return null;
    }

    public void setRejectStatistics(RejectStatistics rejectStatistics) {
        this.rejectStatistics = rejectStatistics;
    }

}
