/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Set;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 * Tests class ErrorsReportFilter.
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ErrorsReportFilterTest {

    @Test
    public void testFilterByDatasetId() throws IOException {
        ErrorsReportFilter filter = new ErrorsReportFilter();

        filter.setSource(getSource());
        filter.setDatasetId("7343X");

        Set<String> result = filter.filter();

        assertEquals(4, result.size());
        assertTrue(result.contains("5006"));
        assertTrue(result.contains("2202"));
        assertTrue(result.contains("5007"));
        assertTrue(result.contains("5008"));
    }

    @Test
    public void testFilterByErrorCode() throws IOException {
        ErrorsReportFilter filter = new ErrorsReportFilter();

        filter.setSource(getSource());
        filter.setErrorCode(2202);

        Set<String> result = filter.filter();

        assertEquals(5, result.size());
        assertTrue(result.contains("7343X"));
        assertTrue(result.contains("03873"));
        assertTrue(result.contains("03881"));
        assertTrue(result.contains("03903"));
        assertTrue(result.contains("04136"));
    }

    private Reader getSource() {
        return new InputStreamReader(
                getClass().getClassLoader().getResourceAsStream(
                "errors-test.txt"));
    }

}
