/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import static org.junit.Assert.*;
import org.junit.Test;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ErrorReportParserTest {

    @Test
    public void testDatasetCount() throws IOException {
        ErrorReportParser parser = new ErrorReportParser();

        parser.parse(getSource());

        assertEquals(7, parser.getDatasetWithErrorsCount());
    }

    public void testErrorCodesCount() throws IOException {
        ErrorReportParser parser = new ErrorReportParser();

        parser.parse(getSource());

        assertEquals(5, parser.getDifferentErrorsCount());
    }

    public void testErrorsCount() throws IOException {
        ErrorReportParser parser = new ErrorReportParser();

        parser.parse(getSource());

        assertEquals(10, parser.getErrorsCount());
    }

    private Reader getSource() {
        return new InputStreamReader(
                getClass().getClassLoader().getResourceAsStream(
                "errors-test.txt"));
    }

}
