/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.ErrorCode;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;

/**
 * Unit Tests for ErrorStatistics.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO more tests
 */
public class ErrorStatisticsTest {

    private ErrorStatistics errorStatistics;

    @Before
    public void before() {
        this.errorStatistics = new ErrorStatistics();
        this.errorStatistics.setErrorLog(new MockErrorLogger());
    }

    @Test
    public void testAddPackageError() {
        errorStatistics.addPackageError(ErrorCode.LIEFERUNG_UNVOLLSTAENDIG);

        Map<ErrorType, Integer> errors = errorStatistics.getPackageErrors();

        assertEquals(1, errors.keySet().size());
    }

    @Test
    public void testAddFieldErrors() {
        errorStatistics.addFieldError("540x", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);

        Map<FieldErrorType, Integer> errors = errorStatistics.getFieldErrors();

        assertEquals(1, errors.keySet().size());
    }

    @Test
    public void testAddSubfieldErrors() {
        errorStatistics.addSubfieldError(ErrorCode.UNTERFELDBEGINN_OHNE_SATZ);

        Map<ErrorType, Integer> errors = errorStatistics.getSubfieldErrors();

        assertEquals(1, errors.keySet().size());
        assertTrue(errors.containsKey(new SubfieldErrorType(ErrorCode.UNTERFELDBEGINN_OHNE_SATZ)));
    }

    @Test
    public void testAddFormatErrors() {
        errorStatistics.addFormatError(ErrorCode.FELDINDIKATOR_FORMATFEHLER);

        Map<ErrorType, Integer> errors = errorStatistics.getFormatErrors();

        assertEquals(1, errors.keySet().size());
        assertTrue(errors.containsKey(new FormatErrorType(ErrorCode.FELDINDIKATOR_FORMATFEHLER)));
    }

    @Test
    public void testAddMixedErrors() {
        errorStatistics.addPackageError(ErrorCode.LIEFERUNG_UNVOLLSTAENDIG);
        errorStatistics.addFieldError("540x", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);
        errorStatistics.addFieldError("600x", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);
        errorStatistics.addSubfieldError(ErrorCode.UNTERFELDBEGINN_OHNE_SATZ);
        errorStatistics.addFormatError(ErrorCode.FELDINDIKATOR_FORMATFEHLER);

        Map<ErrorType, Integer> errors = errorStatistics.getPackageErrors();
        assertEquals(1, errors.keySet().size());

        errors = errorStatistics.getFormatErrors();
        assertEquals(1, errors.keySet().size());

        errors = errorStatistics.getSubfieldErrors();
        assertEquals(1, errors.keySet().size());

        Map<FieldErrorType, Integer> fieldErrors = errorStatistics.getFieldErrors();
        assertEquals(2, fieldErrors.keySet().size());
    }

    @Test
    @Ignore(value="fails on command line using mvn clean install")
    public void testGetFieldErrors() {
        errorStatistics.addFieldError("540x", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);

        Map<FieldErrorType, Integer> fieldErrors = errorStatistics.getFieldErrors();

        assertEquals(1, fieldErrors.keySet().size());

        Map.Entry<FieldErrorType, Integer> entry =
                new ArrayList<Map.Entry<FieldErrorType, Integer>>(fieldErrors.entrySet()).get(0);

        assertEquals("540x", entry.getKey().getBezeichner());
        assertEquals(ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG, entry.getKey().getErrorCode());
        assertEquals(ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG.getCode(), entry.getKey().getCode());
        assertEquals(ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG.getMessage(), entry.getKey().getMessage());
        assertEquals(1, entry.getValue().intValue());
    }

}
