/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.ErrorCode;
import org.junit.Ignore;
import org.junit.Test;

import java.util.TreeMap;

import static org.junit.Assert.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 8/29/12
 * Time: 11:46 AM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class CodeErrorTypeTest {

    @Test
    public void testConstruct() {
        CodeErrorType errorType = new CodeErrorType(ErrorCode.EOF_IN_FELD);

        assertEquals(ErrorCode.EOF_IN_FELD.getCode(), errorType.getCode());
        assertEquals(ErrorCode.EOF_IN_FELD.getMessage(), errorType.getMessage());
    }

    @Test
    public void testPutInTreeMap() {
        CodeErrorType errorType1 = new CodeErrorType(ErrorCode.EOF_IN_FELD);
        CodeErrorType errorType2 = new CodeErrorType(ErrorCode.FELDENDE_OHNE_SATZ);

        TreeMap<ErrorType, String> errors = new TreeMap<ErrorType, String>();

        errors.put(errorType1, "type1");
        errors.put(errorType2, "type2");

        assertEquals(2, errors.keySet().size());
    }

    @Test
    public void testConstructMultipleTimeWithSameCode() {
        CodeErrorType errorType1 = new FieldErrorType("002a", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);
        CodeErrorType errorType2 = new FieldErrorType("002a", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);

        assertTrue(errorType1.equals(errorType2));
    }

    @Test
    public void testSameCodeSameHash() {
        CodeErrorType errorType1 = new FieldErrorType("002a", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);
        // TODO assertEquals(3150, errorType1.getCode());

        CodeErrorType errorType2 = new FieldErrorType("002a", ErrorCode.FELDNUMMER_INDIKATOR_UNZULAESSIG);
        // TODO assertEquals(3150, errorType2.getCode());

        assertTrue(errorType1.getCode() == errorType2.getCode());
        assertTrue(errorType1.getHash() == errorType2.getHash());
    }

}
