/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab;

import org.junit.Test;

import static org.junit.Assert.*;

import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

/**
 *
 */
public class MabFeldComparatorTest {

    @Test
    public void testSorting() throws Exception {
        SortedSet<IMabFeld> felder = new TreeSet<IMabFeld>(new MabFeldComparator());

        felder.add(new MabFeld(331, ' ', "Titel"));
        felder.add(new MabFeld("LOW", ' ', "LIB0001"));
        felder.add(new MabFeld(1, ' ', "ID0001"));
        felder.add(new MabFeld(26, ' ', "mab026value1"));
        felder.add(new MabFeld(26, 'a', "mab026value2"));
        felder.add(new MabFeld(26, 'b', "mab026value3"));

        List<IMabFeld> felderList = new ArrayList<IMabFeld>(felder);

        assertEquals(6, felderList.size());
        assertEquals("001 ", felderList.get(0).getBezeichnung());
        assertEquals("026 ", felderList.get(1).getBezeichnung());
        assertEquals("026a", felderList.get(2).getBezeichnung());
        assertEquals("026b", felderList.get(3).getBezeichnung());
        assertEquals("331 ", felderList.get(4).getBezeichnung());
        assertEquals("LOW ", felderList.get(5).getBezeichnung());

    }

    @Test
    public void testCompareSmaller() {
        MabFeldComparator comparator = new MabFeldComparator();

        MabFeld feld1 = new MabFeld(26, ' ', "feld1");
        MabFeld feld2 = new MabFeld(26, 'a', "feld2");

        assertEquals(-1, comparator.compare(feld1, feld2));
    }

    @Test
    public void testCompareLarger() throws Exception {
        MabFeldComparator comparator = new MabFeldComparator();

        MabFeld feld1 = new MabFeld("LOW", ' ', "feld1");
        MabFeld feld2 = new MabFeld(26, ' ', "feld2");

        assertEquals(1, comparator.compare(feld1, feld2));
    }

    @Test
    public void testCompareEquals() {
        MabFeldComparator comparator = new MabFeldComparator();

        MabFeld feld1 = new MabFeld(26, ' ', "feld1");
        MabFeld feld2 = new MabFeld(26, ' ', "feld2");

        assertEquals(0, comparator.compare(feld1, feld2));
    }

}
