/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab;

import static org.junit.Assert.*;
import org.junit.Test;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class MabExceptionTest {

    @Test
    public void testThrowUnknown() {
        try {
            throw new MabException();
        }
        catch (MabException me) {
            assertEquals(MabException.Description.UNKOWN, me.getDescription());
        }
    }

    @Test
    public void testThrowWithMessage() {
        try {
            throw new MabException("test");

        }
        catch (MabException me) {
            assertEquals("test", me.getMessage());
        }
    }

    @Test
    public void testThrowWithDescription() {
        try {
            throw new MabException(MabException.Description.HEADERLENGTH);
        }
        catch (MabException me) {
            assertEquals(MabException.Description.HEADERLENGTH,
                    me.getDescription());
        }
    }

    @Test
    public void testThrowWithThrowable() {
        Exception cause = new Exception("testCause");
        try {
            throw new MabException(cause);
        }
        catch (MabException me) {
            assertSame(cause, me.getCause());
            assertEquals("testCause", me.getCause().getMessage());
        }
    }

    @Test
    public void testThrowWithMessageAndThrowable() {
        Exception cause = new Exception("testCause");
        try {
            throw new MabException("test", cause);
        }
        catch (MabException me) {
            assertSame(cause, me.getCause());
            assertEquals("testCause", me.getCause().getMessage());
            assertEquals("test", me.getMessage());
        }
    }

    @Test
    public void testThrowWithMessageAndDescription() {
        try {
            throw new MabException("test",
                    MabException.Description.FIELDNUMBERFORMAT);
        }
        catch (MabException me) {
            assertEquals(MabException.Description.FIELDNUMBERFORMAT,
                    me.getDescription());
            assertEquals("test", me.getMessage());
        }
    }

    @Test
    public void testThrowWithMessageAndThrowableAndDescription() {
        Exception cause = new Exception("testCause");
        try {
            throw new MabException("test", cause,
                    MabException.Description.FIELDNUMBERFORMAT);
        }
        catch (MabException me) {
            assertEquals("test", me.getMessage());
            assertSame(cause, me.getCause());
            assertEquals("testCause", me.getCause().getMessage());
            assertEquals(MabException.Description.FIELDNUMBERFORMAT,
                    me.getDescription());
        }
    }

    @Test
    public void testThrowWithThrowableAndDescription() {
        Exception cause = new Exception("testCause");
        try {
            throw new MabException(cause,
                    MabException.Description.FIELDNUMBERFORMAT);
        }
        catch (MabException me) {
            assertSame(cause, me.getCause());
            assertEquals("testCause", me.getCause().getMessage());
            assertEquals(MabException.Description.FIELDNUMBERFORMAT,
                    me.getDescription());
        }
    }

}
