/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.util;

import java.util.*;

/**
 * Created with IntelliJ IDEA.
 * User: jens
 * Date: 9/5/12
 * Time: 2:07 PM
 * To change this template use File | Settings | File Templates.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class SatzfehlerStatistics extends ErrorReportParser {

    private Map<String, Integer> errorsForDataset = new HashMap<String, Integer>();

    @Override
    public void processEntry(final String satzId, final String errorCode) {
        super.processEntry(satzId, errorCode);
        if (errorsForDataset.containsKey(satzId)) {
            int errorCount = errorsForDataset.get(satzId) + 1;
            errorsForDataset.put(satzId, errorCount);
        }
        else {
            errorsForDataset.put(satzId, 1);
        }
    }

    public Map<String, Integer> getErrorsForDataset() {
        return errorsForDataset;
    }

    public Map<Integer, Integer> getNumberOfDatasetsWithErrorCount() {
        Map<Integer, Integer> result = new TreeMap<Integer, Integer>();

        for (Map.Entry<String, Integer> entry : errorsForDataset.entrySet()) {
            int errorCount = entry.getValue();

            if (result.containsKey(errorCount)) {
                result.put(errorCount, result.get(errorCount) + 1);
            }
            else {
                result.put(errorCount, 1);
            }
        }

        return result;
    }

    public Set<String> getDatasetsWithErrorCount(int errorCount) {
        Set<String> saetze = new HashSet<String>();

        for(Map.Entry<String, Integer> entry : errorsForDataset.entrySet()) {
            if (entry.getValue() == errorCount) {
                saetze.add(entry.getKey());
            }
        }

        return saetze;
    }

}
