/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.parser;

import de.kobv.mable.ErrorCode;
import java.util.Queue;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO add function for invalidSatzkennung
 */
public interface ErrorHandler {

    /**
     * Register multiple errors for MAB data package.
     * @param errorqueue Queue of error codes
     */
    void insertLieferungsfehler(Queue<ErrorCode> errorqueue);

    /**
     * Register single error for MAB data package.
     * @param error ErrorCodes
     */
    void insertLieferungsfehler(ErrorCode error);

    /**
     * Register multiple errors for MAB field.
     * @param bezeichner Internal Field identifier
     * @param errorqueue Queue of error codes
     *
     * TODO review signature
     */
    void insertFeldfehler(String bezeichner, Queue<ErrorCode> errorqueue);

    /**
     *
     * @param bezeichner
     * @param error
     *
     * TODO review signature
     */
    void insertFeldfehler(String bezeichner, ErrorCode error);

    void insertSatzfehler(Queue<ErrorCode> errorqueue);

    void insertSatzfehler(ErrorCode error);

    void insertUnterfeldfehler(Queue<ErrorCode> errorqueue);

    void insertUnterfeldfehler(ErrorCode error);

    // Reject Methods

    void rejectDataset(ErrorCode errorCode, String mab001, String content,
            boolean endOfFile);

    void rejectField(ErrorCode errorCode, String content);

    void rejectSubfield(ErrorCode errorCode, String content);

    void addRejectError(ErrorCode errorCode);

    void endReject();


}
