/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.parser;

import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.MabSatzkennung;
import org.apache.log4j.Logger;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class DefaultContentHandler implements ContentHandler {

    private static final Logger LOG = Logger.getLogger(
            DefaultContentHandler.class);

    @Override
    public void endParsing() {
        LOG.debug("endParsing");
    }

    @Override
    public void endSatz() {
        LOG.debug("endSatz");
    }

    @Override
    public void startFeld(String fieldNumber, char indicator, String content) {
        LOG.debug("startFeld(" + fieldNumber + ", " + indicator + ", " + content + ")");
    }

    @Override
    public void startParsing() {
        LOG.debug("startParsing");
    }

    @Override
    public void startSatz(MabSatzkennung satzkennung) {
        LOG.debug("startSatz(" + satzkennung + ")");
    }

    @Override
    public void startUnterfeld(char kennzeichen, String content) {
        LOG.debug("startUnterfeld(" + kennzeichen + ", " + content + ")");
    }

    @Override
    public MabSatz getCurrentDataset() {
        return null;
    }

    @Override
    public String getLastDatasetId() {
        return null;
    }

}
