/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.parser;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.MabSatz;
import de.kobv.mable.mab.MabSatzkennung;

/**
 * Interface for class handling MAB data parsing events.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public interface ContentHandler {

    /**
     * Called at the begin of parsing.
     *
     * TODO do we really need MableConfigurationException?
     */
    void startParsing() throws MableConfigurationException;

    /**
     * Called after the parsing is finished.
     */
    void endParsing();

    /**
     * Called when a MAB dataset is found.
     * @param satzkennung MAB2 Satzkennung
     */
    void startSatz(MabSatzkennung satzkennung);

    /**
     * called when a MAB dataset has been parsed.
     */
    void endSatz();

    /**
     * Called for every MAB category.
     * @param fieldNumber Number of category (MAB Feld)
     * @param indicator Leader of category (Indikator)
     * @param content Content (Inhalt)
     */
    void startFeld(String fieldNumber, char indicator, String content);

    void startUnterfeld(char kennzeichen, String content);

    public MabSatz getCurrentDataset();

    public String getLastDatasetId();

}
