/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.ErrorCode;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class RejectStatistics {

    private Map<ErrorCode, Integer> ignoredDatasetErrors = new EnumMap<ErrorCode, Integer>(ErrorCode.class);

    private Map<ErrorCode, Integer> ignoredFieldErrors = new EnumMap<ErrorCode, Integer>(ErrorCode.class);

    private Map<ErrorCode, Integer> ignoredSubfieldErrors = new EnumMap<ErrorCode, Integer>(ErrorCode.class);

    private Map<String, Integer> ignoredFields = new HashMap<String, Integer>();

    public void addIgnoredDataset(final ErrorCode errorCode,
            final String mab001) {
        int count = 0;
        if (ignoredDatasetErrors.containsKey(errorCode)) {
            count = ignoredDatasetErrors.get(errorCode);
        }
        ignoredDatasetErrors.put(errorCode, count + 1);
    }

    public void addIgnoredField(final ErrorCode errorCode,
            final String content) {
        int count = 0;
        if (ignoredFieldErrors.containsKey(errorCode)) {
            count = ignoredFieldErrors.get(errorCode);
        }
        ignoredFieldErrors.put(errorCode, count + 1);

        String category = content.substring(0, 4);
        count = 0;
        if (ignoredFields.containsKey(category)) {
            count = ignoredFields.get(category);
        }
        ignoredFields.put(category, count + 1);
    }

    public void addIgnoredSubfield(final ErrorCode errorCode,
            final String content) {
        int count = 0;
        if (ignoredSubfieldErrors.containsKey(errorCode)) {
            count = ignoredSubfieldErrors.get(errorCode);
        }
        ignoredSubfieldErrors.put(errorCode, count + 1);
    }

    public Map<String, Integer> getFieldCount() {
        return new TreeMap<String, Integer>(ignoredFields);
    }

}
