/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab.extension;

import de.kobv.mable.ErrorCode;
import org.apache.commons.lang.builder.HashCodeBuilder;

/**
 * Basisklasse für Mable Fehler.
 *
 * Jede erbende Klasse muß *** implementieren, um verschiedene Fehlertypen unterscheiden zu können. Die Klasse alleine
 * reicht in vielen Fällen nicht aus.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class DatasetError extends MableError {

    /**
     * Identifikation des betroffenen Satzes.
     */
    private String satzId;

    /**
     * Fehlertyp.
     */
    private ErrorType errorType;

    /**
     * Erzeugt Instanz von DatasetError für Satz.
     * @param satzId Satzidentifikation (MAB001)
     * @deprecated remove
     */
    public DatasetError(String satzId) {
        this.satzId = satzId;
    }

    /**
     * Erzeugt Instanz von DatasetError für Satz mit einem bestimmten Fehlertyp.
     * @param satzId Satzidentifikation
     * @param type ErrorType
     *
     * TODO throw runtime exception if type is null
     */
    public DatasetError(ErrorType type, String satzId) {
        this.satzId = satzId;
        this.errorType = type;
    }

    /**
     * Liefert Satzidentifikation (MAB001) zurück.
     * @return String
     */
    public String getSatzId() {
        return satzId;
    }

    /**
     * Liefert Fehlertyp zurück.
     * @return ErrorType
     */
    public ErrorType getErrorType() {
        return errorType;
    }

    public String toString() {
        return super.toString() + "[" + getErrorType() + "]";
    }

}
