/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab;

import de.ddb.charset.MabCharset;

/**
 * Class representing MAB subfield.
 *
 * @author Pascal-Nicolas Becker <becker(at)zib.de>
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public final class MabUnterfeld implements IMabUnterfeld {

    /**
     * Kennzeichen des Unterfeldes.
     */
    private char kennzeichen;

    /**
     * Content of subfield.
     */
    private String inhalt;

    /**
     * Creates subfield with ID and content.
     * @param subfieldId Identifier for subfield
     * @param content Content of subfield
     */
    public MabUnterfeld(final char subfieldId, final String content) {
        this.kennzeichen = subfieldId;
        this.inhalt = content;
    }

    /**
     * Converts subfield to a formatted string.
     * @return Subfield as String
     */
    @Override
    public String toString() {
        return Character.toString(MabCharset.UNTERFELDBEGINNZEICHEN)
            + Character.toString(this.kennzeichen)
            + this.inhalt;
    }

    /**
     * Liefert Unterfeldkennzeichen.
     * @return char
     */
    @Override
    public char getKennzeichen() {
        return kennzeichen;
    }

    /**
     * Setzt Unterfeldkennzeichen.
     * @param kennzeichen MAB2 Unterfeldkennzeichen
     */
    @Override
    public void setKennzeichen(final char kennzeichen) {
        this.kennzeichen = kennzeichen;
    }

    /**
     * Liefert Unterfeldinhalt zurück.
     * @return String
     */
    @Override
    public String getContent() {
        return inhalt;
    }

    /**
     * Setzt Unterfeldinhalt.
     * @param content String
     */
    @Override
    public void setContent(final String content) {
        this.inhalt = content;
    }

}
