/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab;

import java.util.Comparator;

/**
 * Vergleicht zwei MabFeld Objekte.
 *
 * Die Sortierreihenfolge sollte zuerst die MAB2 Felder mit aufsteigenden Nummern und dann die Aleph bzw. nicht MAB2
 * konformen Felder sein, also zum Beispiel "001, 026, 331, LOW".
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class MabFeldComparator implements Comparator<IMabFeld> {

    @Override
    public int compare(IMabFeld feld1, IMabFeld feld2) {
        String f1name = feld1.getBezeichnung();
        String f2name = feld2.getBezeichnung();

        int result = f1name.compareTo(f2name);

        if (result < 0) {
            return -1;
        }
        else if (result > 0) {
            return 1;
        }
        else {
            return 0;
        }
    }

}
