/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab;

import java.util.List;

/**
 * Interface for class representing MAB2 Satz.
 *
 * Das Interface erlaubt es Informationen über einen Satz und dessen Felder abzufragen und zu modifizieren.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO review naming of methods (consistency)
 */
public interface IMabSatz {

    /**
     * Fügt ein Feld zum Satz hinzu.
     * @param feld IMabFeld
     */
    public void addFeld(IMabFeld feld);

    /**
     * Entfernt ein Feld vom Satz.
     * @param feld IMabFeld
     */
    public void removeFeld(IMabFeld feld);

    /**
     * Prüft, ob Felder für eine Kategorie vorhanden sind.
     * @param category Bezeichner für Kategorie (3 Zeichen, Feldnummer)
     * @return true - wenn passende Felder vorhanden sind
     */
    public boolean isFeldPresent(String category);

    public boolean isFeldPresent(String category, char indikator);

    /**
     * Liefert sämtlich Felder des MAB Satzes zurück.
     * @return List<IMabFeld> mit Felder
     */
    public List<IMabFeld> getFelder();

    /**
     * Liefert alle Felder für eine Kategorie (Feldnummer + Indikator) zurück.
     *
     * @param category String mit vier Zeichen
     * @return Liste mit MAB Feldern
     */
    public List<IMabFeld> getFelder(String category);

    public List<IMabFeld> getFelder(String category, char indikator);

    /**
     * Liefert alle Felder mit der MAB2 Feldnummer zurück, unabhängig vom Indikator.
     *
     * @param feldDef MabFeldDefinition
     * @return List mit MAB Feldern
     */
    public List<IMabFeld> getFelder(MabFeldDefinition feldDef);

    /**
     * Liefert die Satzkennung zurück.
     * @return MabSatzkennung
     */
    public MabSatzkennung getSatzkennung();

    /**
     * Liefert den Inhalt des MAB001 Feldes zurück.
     *
     * Liefert NULL, wenn kein MAB001 Feld vorhanden ist.
     *
     * @return String MAB001 ID für Satz
     */
    public String getId();

}
