/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.mab;

import java.util.List;

/**
 * Interface for class representing MAB2 Feld.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public interface IMabFeld {

    /**
     * Fügt ein Unterfeld hinzu.
     * @param unterfeld IMabUnterfeld
     */
    public void addSubfield(IMabUnterfeld unterfeld);

    /**
     * Entfernt ein Unterfeld.
     * @param unterfeld IMabUnterfeld
     */
    public void removeSubfield(IMabUnterfeld unterfeld);

    /**
     * Liefert Liste mit Unterfeldern zurück.
     * @return Liste mit Unterfeldern
     */
    public List<IMabUnterfeld> getUnterfelder();

    /**
     * Ersetzt Unterfelder des Feldes.
     * @param unterfelder Liste mit Unterfeldern
     */
    public void setUnterfelder(List<IMabUnterfeld> unterfelder);

    /**
     * Liefert 'true' wenn das Feld Unterfelder besitzt.
     * @return true wenn Feld Unterfelder hat, sonst false
     */
    public boolean hatUnterfelder();

    /**
     * Liefert 'true' wenn das Feld einen Inhalt hat.
     * @return true wenn Feld Inhalt hat, sonst false
     */
    public boolean hatInhalt();

    /**
     * Liefert den Inhalt des Feldes zurück.
     * @return String
     */
    public String getInhalt();

    /**
     * Setzt Inhalt des Feldes.
     * @param inhalt String
     */
    public void setInhalt(String inhalt);

    /**
     * Liefert die Bezeichnung des Feldes zurück (Feldnummer + Indikator).
     * @return String
     */
    public String getBezeichnung();

    /**
     * Liefert die Feldnummer zurück.
     * @return int
     */
    public int getFeldnummer();

    /**
     * Liefert den Indikator zurück.
     * @return int
     *
     * TODO Why an 'int'?
     */
    public int getIndikator();

}
