/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.config;

import de.kobv.mable.common.MableConfigurationException;
import de.kobv.mable.mab.extension.MableModule2;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * Loads Mable module configuration from Spring configuration XML file.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO handle configuration errors
 */
public class DefaultMableConfig2 implements MableConfig, ApplicationContextAware {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(DefaultMableConfig2.class);

    /**
     * Path to default configuration file.
     */
    private static final String DEFAULT_CONFIG = "de/kobv/mable/cli/mable-checks2.xml";

    /**
     * Path to configuration file.
     */
    private String configPath = null;

    private ApplicationContext parentContext;

    /**
     * Returns set of configured modules.
     * @return Set of MableModule2 objects
     */
    @Override
    public final Set<MableModule2> getModules() throws MableConfigurationException {
        Set<MableModule2> modules = new HashSet<MableModule2>();

        String[] configs = new String[] { getConfigPath() };

        ApplicationContext context = new ClassPathXmlApplicationContext(configs, parentContext);

        modules.addAll(getModulesFromContext(parentContext));
        modules.addAll(getModulesFromContext(context));

        return modules;
    }

    protected Set<MableModule2> getModulesFromContext(ApplicationContext context) {
        Set<MableModule2> modules = new HashSet<MableModule2>();

        Map<String, MableModule2> beans = context.getBeansOfType(MableModule2.class);

        for (Map.Entry<String, MableModule2> entry : beans.entrySet()) {
            MableModule2 module = entry.getValue();
            modules.add(module);
        }

        return modules;
    }

    /**
     * Set path to configuration file.
     * @param path String Classpath to configuration file
     */
    public void setConfigPath(final String path) {
        this.configPath = path;
    }

    /**
     * Returns path to configuration file.
     * @return String path to configuration file
     */
    private String getConfigPath() {
        if (configPath != null) {
            return configPath;
        }
        else {
            return DEFAULT_CONFIG;
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentContext = applicationContext;
    }
}
