/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.common;

/**
 * Gibt an, dass das Format der einzulesenden Quelle unbekannt ist.
 * @author Pascal-Nicolas Becker <becker(at)zib.de>
 * @see de.kobv.mable.kernels.MAB2DBKernel.Format
 */
public class UnknownFormatException extends Exception {

    /**
     * @see Exception#Exception()
     */
    public UnknownFormatException() {
    }

    /**
     * @see Exception#Exception(String)
     * @param message Exception message
     */
    public UnknownFormatException(final String message) {
        super(message);
    }

    /**
     * @see Exception#Exception(Throwable)
     * @param cause Throwable object
     */
    public UnknownFormatException(final Throwable cause) {
        super(cause);
    }

    /**
     * @see Exception#Exception(String, Throwable)
     * @param message Exception message
     * @param cause Throwable object
     */
    public UnknownFormatException(final String message, final Throwable cause) {
        super(message, cause);
    }
}
