/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.cli;

import de.kobv.mable.config.DefaultMableConfig2;
import de.kobv.mable.mab.extension.MableModule2;
import de.kobv.mable.mab2.modules.DatasetStatistics;
import de.kobv.mable.mab2.modules.Reference;
import de.kobv.mable.mab2.modules.ReferencesHolder;
import de.kobv.mable.util.XmlResourceBundleControl;
import gov.ornl.sns.cli.CommandLineHelper;
import java.util.ResourceBundle;
import java.util.Set;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import org.junit.Test;
import org.junit.Ignore;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

/**
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class ConfigurationTest {

    @Test
    public void testLoadCliConfiguration() {
        Mable app = new Mable();

        CommandLineHelper clh = app.getCommandLineHelper();

        clh.run(new String[]{
                    "-v"
                });
    }

    @Test
    public void testAutowiring() throws Exception {
        DefaultMableConfig2 config = new DefaultMableConfig2();

        String CONFIG_FILE = "de/kobv/mable/cli/spring-config-nosql2.xml";

        ApplicationContext context =
                new ClassPathXmlApplicationContext(CONFIG_FILE);

        config.setApplicationContext(context);

        Set<MableModule2> modules = config.getModules();

        for (MableModule2 module : modules) {
            if (module instanceof Reference) {
                assertNotNull(((Reference) module).getReferencesStore());
            } else if (module instanceof ReferencesHolder) {
                assertNotNull(((ReferencesHolder) module).getReferencesStore());
            }
        }
    }

    @Test
    public void testLineBreaks() {
        ResourceBundle messages = ResourceBundle.getBundle("de/kobv/mable/cli/mable-cli-messages",
                new XmlResourceBundleControl());

        String message = messages.getString("mable.cli.header");

        System.out.println(message);
    }

    @Test
    public void testCheckCommand() {

    }

    @Test
    @Ignore(value = "fix configuration after MABLE-263")
    public void testInternalConfiguration() {
        String CONFIG_FILE = "de/kobv/mable/cli/spring-config-nosql.xml";

        ApplicationContext context =
                new ClassPathXmlApplicationContext(CONFIG_FILE);

        assertNotNull(context);
    }

    @Test
    public void testInternalConfiguration2() {
        String CONFIG_FILE = "de/kobv/mable/cli/spring-config-nosql2.xml";

        ApplicationContext context =
                new ClassPathXmlApplicationContext(CONFIG_FILE);

        assertNotNull(context);
    }

    @Test
    public void testLoadingModules() throws Exception {
        DefaultMableConfig2 config = new DefaultMableConfig2();

        String CONFIG_FILE = "de/kobv/mable/cli/spring-config-nosql2.xml";

        ApplicationContext context =
                new ClassPathXmlApplicationContext(CONFIG_FILE);

        config.setApplicationContext(context);

        Set<MableModule2> modules = config.getModules();

        assertNotNull(modules);
        assertTrue(modules.size() > 0);

        boolean foundDatasetStatistics = false;

        for(MableModule2 module : modules) {
            if (module instanceof DatasetStatistics) {
                foundDatasetStatistics = true;
            }
        }

        assertTrue(foundDatasetStatistics);
    }

}
