/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.kernels;

import java.util.Properties;

/**
 * <p>
 * Der Kernel bündelt derzeit vor allem Methoden um das Auslesen der
 * Konfigurationsdatei, das Auslesen der Tabellen- und Spaltennamen der
 * Datenbank, aber auch den Zugriff auf den RootLogger.
 * </p><p>
 * Alle Kernel, die auf die Konfigurationsdateien und die Datenbank zugreifen
 * sollten von diesem Kernel erben. Hier finden sich derzeit vor allem Fu
 * </p>
 * @author Pascal-Nicolas Becker <becker(at)zib.de>
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public abstract class AbstractKernel {

    /**
     * Konfiguration properties.
     *
     * TODO replace with Configuration object?
     */
    private Properties configuration;

    /**
     * Setter for configuration properties.
     * @param config Configuration properties
     */
    public final void setConfiguration(final Properties config) {
        this.configuration = config;
    }

    /**
     * Getter for configuration properties.
     * @return Properties containing configuration parameters
     */
    public final Properties getConfiguration() {
        return this.configuration;
    }

}
