/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.cli;

import de.kobv.mable.mab.parser.MabDatasetIndexer;
import java.io.*;
import org.apache.log4j.Logger;

/**
 * Command for creating index of datasets in file.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class IndexCommand extends AbstractMableCommand {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(IndexCommand.class);

    private String outputFile;

    @Override
    public void execute() {
        InputStream source = getSource();

        if (source == null) {
            return;
        }

        MabDatasetIndexer indexer = new MabDatasetIndexer();


        long totalTime = 0;

        try {
            Writer output = getOutput();
            indexer.setOutput(output);
            indexer.setSource(source);

            long timestamp = System.currentTimeMillis();

            indexer.index();

            totalTime = System.currentTimeMillis() - timestamp;

            output.close();

            if (!isQuietMode()) {
                // TODO use resources
                getOutput().write(String.format("%1$d S\u00e4tze durchsucht (%2$d ms)%n", indexer.getDatasetCounter(),
                        totalTime));
            }
        }
        catch (IOException e) {
            LOG.error("", e);
        }
    }

    private InputStream getSource() {
        InputStream source = null;

        try {
            source = new BufferedInputStream(
                    new FileInputStream(getFilename()));
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(getMessages().getString("error.fileNotFound"));
        }

        return source;
    }

    private Writer getOutput() throws IOException {
        if (outputFile == null) {
            Console console = System.console();
            if (console != null) {
                return System.console().writer();
            }
            else {
                return new OutputStreamWriter(System.out);
            }
        }
        else {
            return new FileWriter(outputFile);
        }
    }

    public String getOutputFile() {
        return outputFile;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

}
