/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.cli;

import de.kobv.mable.ErrorCode;
import de.kobv.mable.util.ErrorsReportFilter;
import java.io.*;
import java.util.Set;
import org.apache.log4j.Logger;

/**
 * Filters errors report file by dataset id or error code.
 *
 * This command can be used by Windows users instead of the grep command that
 * is available on other platforms.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 *
 * TODO simplify finding error file
 * TODO support brief and extended version of output
 */
public class FilterErrorsCommand extends AbstractMableCommand {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(
            FilterErrorsCommand.class);

    /**
     * Error codes for filtering.
     */
    private int errorCode;

    /**
     * Dataset identifier for filtering.
     */
    private String datasetId;

    /**
     * Execute filtering.
     */
    @Override
    public void execute() {
        // open error file
        // check format
        // get result
        // output result

        String filename = getFilename();

        File file = new File(filename);

        if (file.exists() && file.isFile()) {
        }
        else {

        }

        Reader source;

        Set<String> result;

        try {
            source = new FileReader(getFilename());

            ErrorsReportFilter filter = new ErrorsReportFilter();
            filter.setSource(source);
            filter.setErrorCode(getErrorCode());
            filter.setDatasetId(getDatasetId());
            result = filter.filter();

            if (getDatasetId() != null) {
                System.out.println("For dataset " + getDatasetId() + " the following errors were found:");

                // TODO refactor! not all codes come from ErrorCode!
                for (String error : result) {
                    ErrorCode code = ErrorCode.get(Integer.parseInt(error));

                    if (code != null) {
                        System.out.println(error + " : " + code.getMessage());
                    }
                    else {
                        System.out.println(error + " : " + "NO INFO");
                    }
                }
            }
            else {
                for (String id : result) {
                    System.out.println(id);
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            return;
        }
        catch (IOException ioe) {
            return;
        }

        System.out.println("Results found: " + result.size());
    }

    /**
     * Getter for datasetId option value.
     *
     * @return
     */
    public String getDatasetId() {
        return datasetId;
    }

    /**
     * Setter for datasetId option value.
     * @param datasetId
     */
    public void setDatasetId(String datasetId) {
        this.datasetId = datasetId;
    }

    /**
     * Getter for error code option value.
     * @return
     */
    public int getErrorCode() {
        return errorCode;
    }

    /**
     * Setter for error code option value.
     * @param
     */
    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

}
