/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.cli;

import de.kobv.mable.mab.parser.MabDatasetCounter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.log4j.Logger;

/**
 * Counts datasets in a MAB file by count dataset end characters.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public class CountCommand extends AbstractMableCommand {

    /**
     * Logger for this class.
     */
    private static final Logger LOG = Logger.getLogger(CountCommand.class);

    /**
     * Executes count.
     */
    @Override
    public void execute() {
        Reader source;
        try {
            source = new FileReader(getFilename());
        }
        catch (FileNotFoundException fnfe) {
            LOG.error(getMessages().getString("error.fileNotFound"));
            return;
        }

        MabDatasetCounter counter = new MabDatasetCounter();

        counter.setSource(source);

        long totalTime = 0;

        try {
            long timestamp = System.currentTimeMillis();
            counter.parse();
            totalTime = System.currentTimeMillis() - timestamp;
        }
        catch (IOException e) {
            LOG.error("", e);
        }

        System.console().writer().println(counter.getDatasetCounter() + " S\u00e4tze gefunden (" + totalTime + " ms)");
    }

}
