/*
 * This file is part of Mable+, a program for checking MAB data for errors.
 *
 * Copyright (C) 2008, 2011-2012 Kooperativer Bibliotheksverbund
 * Berlin-Brandenburg (KOBV) <http://www.kobv.de>,
 * im Konrad-Zuse-Zentrum für Informationstechnik
 * Berlin (ZIB) <http://www.zib.de>, Takustr. 7, D-14195 Berlin-Dahlem
 * Author(s) Jens Schwidder, <schwidder(at)zib.de>,
 *           Pascal-Nicolas Becker, <becker(at)zib.de>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the Free
 * Software Foundation, either version 3 of the License, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 */
package de.kobv.mable.cli;

import gov.ornl.sns.cli.DefaultSubCommand;

/**
 * Abstract basic command immplementation for Mable.
 *
 * @author Jens Schwidder <schwidder(at)zib.de>
 */
public abstract class AbstractMableCommand extends DefaultSubCommand {

    /**
     * Name of MAB file.
     */
    private String filename;

    /**
     * Flag for MAB files that are UTF8 encoded.
     */
    private boolean utf8encoded = false;

    /**
     * Switch for quiet mode that hides all extra output to console.
     */
    private boolean quietMode;

    /**
     * Getter for MAB filename.
     * @return Path to MAB file
     */
    public String getFilename() {
        return filename;
    }

    /**
     * Setter for MAB filename.
     * @param filename Path to MAB file
     */
    public void setFilename(final String fname) {
        this.filename = fname;
    }

    /**
     * Getter for option value utf8encoded.
     * @return true - use UTF-8 encoding, false - use MAB2 encoding
     */
    public boolean isUtf8encoded() {
        return utf8encoded;
    }

    /**
     * Setter for option value utf8encoded.
     * @param utf8enc true - use UTF8 encoding, false - use MAB2 encoding
     */
    public void setUtf8encoded(final boolean utf8enc) {
        this.utf8encoded = utf8enc;
    }

    /**
     * Getter for quiet mode status.
     * @return true - if quiet mode is enabled; false - if disabled
     */
    public boolean isQuietMode() {
        return quietMode;
    }

    /**
     * Setter for enabling/disabling quiet mode.
     * @param quietMode true - enabled quiet mode; false - disables quiet mode
     */
    public void setQuietMode(final boolean quietMode) {
        this.quietMode = quietMode;
    }

}
