@REM ----------------------------------------------------------------------------
@REM Copyright 2001-2004 The Apache Software Foundation.
@REM
@REM Licensed under the Apache License, Version 2.0 (the "License");
@REM you may not use this file except in compliance with the License.
@REM You may obtain a copy of the License at
@REM
@REM      http://www.apache.org/licenses/LICENSE-2.0
@REM
@REM Unless required by applicable law or agreed to in writing, software
@REM distributed under the License is distributed on an "AS IS" BASIS,
@REM WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
@REM See the License for the specific language governing permissions and
@REM limitations under the License.
@REM ----------------------------------------------------------------------------
@REM

@echo off

set ERROR_CODE=0

:init
@REM Decide how to startup depending on the version of windows

@REM -- Win98ME
if NOT "%OS%"=="Windows_NT" goto Win9xArg

@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" @setlocal

@REM -- 4NT shell
if "%eval[2+2]" == "4" goto 4NTArgs

@REM -- Regular WinNT shell
set CMD_LINE_ARGS=%*
goto WinNTGetScriptDir

@REM The 4NT Shell from jp software
:4NTArgs
set CMD_LINE_ARGS=%$
goto WinNTGetScriptDir

:Win9xArg
@REM Slurp the command line arguments.  This loop allows for an unlimited number
@REM of arguments (up to the command line limit, anyway).
set CMD_LINE_ARGS=
:Win9xApp
if %1a==a goto Win9xGetScriptDir
set CMD_LINE_ARGS=%CMD_LINE_ARGS% %1
shift
goto Win9xApp

:Win9xGetScriptDir
set SAVEDIR=%CD%
%0\
cd %0\..\.. 
set BASEDIR=%CD%
cd %SAVEDIR%
set SAVE_DIR=
goto repoSetup

:WinNTGetScriptDir
set BASEDIR=%~dp0\..

:repoSetup


if "%JAVACMD%"=="" set JAVACMD=java

if "%REPO%"=="" set REPO=%BASEDIR%\repo

set CLASSPATH="%BASEDIR%"\etc;"%REPO%"\mable-core-1.1.jar;"%REPO%"\dnb-charsets-1.2.22.jar;"%REPO%"\log4j-1.2.16.jar;"%REPO%"\spring-context-3.1.1.RELEASE.jar;"%REPO%"\spring-expression-3.1.1.RELEASE.jar;"%REPO%"\spring-asm-3.1.1.RELEASE.jar;"%REPO%"\spring-aop-3.1.1.RELEASE.jar;"%REPO%"\aopalliance-1.0.jar;"%REPO%"\aspectjrt-1.7.0.jar;"%REPO%"\aspectjweaver-1.7.0.jar;"%REPO%"\slf4j-log4j13-1.0.1.jar;"%REPO%"\commons-configuration-1.6.jar;"%REPO%"\commons-collections-3.2.1.jar;"%REPO%"\commons-logging-1.1.1.jar;"%REPO%"\commons-digester-1.8.jar;"%REPO%"\commons-jxpath-1.3.jar;"%REPO%"\commons-validator-1.4.0.jar;"%REPO%"\commons-beanutils-1.8.3.jar;"%REPO%"\mable-mab-1.1.jar;"%REPO%"\mable-report-1.1.jar;"%REPO%"\mable-util-1.1.jar;"%REPO%"\spring-jdbc-3.1.1.RELEASE.jar;"%REPO%"\spring-beans-3.1.1.RELEASE.jar;"%REPO%"\spring-core-3.1.1.RELEASE.jar;"%REPO%"\spring-tx-3.1.1.RELEASE.jar;"%REPO%"\commons-lang-2.5.jar;"%REPO%"\commons-io-2.1.jar;"%REPO%"\commons-cli-1.2.jar;"%REPO%"\cli-utils-1.3-RC2.jar;"%REPO%"\spring-context-support-3.0.5.RELEASE.jar;"%REPO%"\commons-beanutils-core-1.8.3.jar;"%REPO%"\mable-cli-1.1.jar
set EXTRA_JVM_ARGUMENTS=-Dmable.log.path=$MABLE_HOME/logs -Dlog4j.configuration=de/kobv/mable/cli/log4j.xml -enableassertions
goto endInit

@REM Reaching here means variables are defined and arguments have been captured
:endInit

%JAVACMD% %JAVA_OPTS% %EXTRA_JVM_ARGUMENTS% -classpath %CLASSPATH_PREFIX%;%CLASSPATH% -Dapp.name="mable" -Dapp.repo="%REPO%" -Dbasedir="%BASEDIR%" de.kobv.mable.cli.Mable %CMD_LINE_ARGS%
if ERRORLEVEL 1 goto error
goto end

:error
if "%OS%"=="Windows_NT" @endlocal
set ERROR_CODE=1

:end
@REM set local scope for the variables with windows NT shell
if "%OS%"=="Windows_NT" goto endNT

@REM For old DOS remove the set variables from ENV - we assume they were not set
@REM before we started - at least we don't leave any baggage around
set CMD_LINE_ARGS=
goto postExec

:endNT
@endlocal

:postExec

if "%FORCE_EXIT_ON_ERROR%" == "on" (
  if %ERROR_CODE% NEQ 0 exit %ERROR_CODE%
)

exit /B %ERROR_CODE%
