/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.reports;

import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab.extension.IErrorStatistics;
import de.kobv.mable.reports.AbstractReport;
import de.kobv.mable.util.XmlResourceBundleControl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.log4j.Logger;

public class SatzfehlerReport
extends AbstractReport {
    private String noErrorsMessage = "Es gab keine Satzfehler.";
    private ResourceBundle errorMessages = ResourceBundle.getBundle("de/kobv/mable/messages", (ResourceBundle.Control)new XmlResourceBundleControl());
    private IErrorStatistics datasetErrorStatistics;
    private Set<String> excludeTypes = null;

    @Override
    public void generate() {
        Logger report = this.getReport();
        Map<ErrorType, Integer> result = this.getResult();
        StringWriter strOut = new StringWriter();
        PrintWriter out = new PrintWriter(strOut);
        out.println();
        out.println(this.getHeader());
        out.println();
        if (result.isEmpty()) {
            out.println(this.getNoErrorsMessage());
        } else {
            out.println(" Anzahl -> Fehlermeldung");
            int maxDigits = Integer.toString(this.findLongestValue(result)).length();
            for (Map.Entry<ErrorType, Integer> entry : result.entrySet()) {
                ErrorType errorType = entry.getKey();
                if (this.excludeTypes != null && this.excludeTypes.contains(errorType.getClass().getCanonicalName())) continue;
                out.println(String.format(" %1$" + maxDigits + "d -> (#%2$d) %3$s", entry.getValue(), errorType.getCode(), this.getErrorMessage(errorType)));
            }
        }
        report.info((Object)strOut.toString());
    }

    protected String getErrorMessage(ErrorType errorType) {
        String messageKey;
        String errorMessage = errorType.getMessage();
        if (errorMessage == null && (messageKey = errorType.getMessage()) != null) {
            errorMessage = this.errorMessages.getString(messageKey);
        }
        return errorMessage;
    }

    protected int findLongestValue(Map<ErrorType, Integer> result) {
        int largestValue = 0;
        for (Map.Entry<ErrorType, Integer> entry : result.entrySet()) {
            if (entry.getValue() <= largestValue) continue;
            largestValue = entry.getValue();
        }
        return largestValue;
    }

    public Map<ErrorType, Integer> getResult() {
        return this.getDatasetErrorStatistics().getDatasetErrors();
    }

    public String getNoErrorsMessage() {
        return this.noErrorsMessage;
    }

    public void setNoErrorsMessage(String message) {
        this.noErrorsMessage = message;
    }

    public IErrorStatistics getDatasetErrorStatistics() {
        return this.datasetErrorStatistics;
    }

    public void setDatasetErrorStatistics(IErrorStatistics errorStatistics) {
        this.datasetErrorStatistics = errorStatistics;
    }

    public Set<String> getExcludeTypes() {
        return this.excludeTypes;
    }

    public void setExcludeTypes(Set<String> excludeTypes) {
        this.excludeTypes = excludeTypes;
    }
}

