/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.reports;

import de.kobv.mable.mab.extension.ErrorStatistics;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.reports.AbstractReport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import org.apache.log4j.Logger;

public class LieferungsfehlerReport
extends AbstractReport {
    private String noErrorsMessage = "Es gab keine Lieferungsfehler.";
    private ErrorStatistics errorStatistics;

    @Override
    public void generate() {
        Logger report = this.getReport();
        Map<ErrorType, Integer> result = this.getResult();
        StringWriter strOut = new StringWriter();
        PrintWriter out = new PrintWriter(strOut);
        out.println();
        out.println(this.getHeader());
        out.println();
        if (result.isEmpty()) {
            out.println(this.getNoErrorsMessage());
        } else {
            out.println(" Anzahl -> Fehlermeldung");
            for (Map.Entry<ErrorType, Integer> entry : result.entrySet()) {
                out.println(" " + entry.getValue() + " -> (#" + entry.getKey().getCode() + ") " + entry.getKey().getMessage());
            }
        }
        report.info((Object)strOut.toString());
    }

    public String getNoErrorsMessage() {
        return this.noErrorsMessage;
    }

    public void setNoErrorsMessage(String message) {
        this.noErrorsMessage = message;
    }

    public Map<ErrorType, Integer> getResult() {
        return this.getErrorStatistics().getPackageErrors();
    }

    public ErrorStatistics getErrorStatistics() {
        return this.errorStatistics;
    }

    public void setErrorStatistics(ErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }
}

