/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.reports;

import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab2.modules.IsbnErrorType;
import de.kobv.mable.mab2.modules.IsbnStatistics;
import de.kobv.mable.reports.SatzfehlerReport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class IsbnReport
extends SatzfehlerReport
implements IsbnStatistics {
    private Map<IsbnErrorType.Reason, Integer> errorTypes = new EnumMap<IsbnErrorType.Reason, Integer>(IsbnErrorType.Reason.class);

    @Override
    public void generate() {
        Logger report = this.getReport();
        Map<ErrorType, Integer> result = this.getResult();
        StringWriter strOut = new StringWriter();
        PrintWriter out = new PrintWriter(strOut);
        out.println();
        out.println("--- ISBN Fehler (MAB 540) ---");
        out.println();
        if (result.isEmpty()) {
            out.println("Es wurden keine ISBN Fehler gefunden.");
        } else {
            out.println(" Anzahl -> Fehlermeldung");
            int maxDigits = this.getRequiredDigitsForValues(result.values());
            for (Map.Entry<ErrorType, Integer> entry : result.entrySet()) {
                ErrorType errorType = entry.getKey();
                if (!(errorType instanceof IsbnErrorType)) continue;
                out.println(String.format("  %1$" + maxDigits + "d -> (#%2$d) %3$s", entry.getValue(), errorType.getCode(), this.getErrorMessage(errorType)));
            }
            out.println();
            out.println(" M\u00f6gliche Gr\u00fcnde f\u00fcr inkorrekte ISBNs in 540a");
            maxDigits = this.getRequiredDigitsForValues(this.errorTypes.values());
            for (Map.Entry<ErrorType, Integer> entry : this.errorTypes.entrySet()) {
                out.println(String.format("  %1$" + maxDigits + "d -> %2$s", entry.getValue(), ((IsbnErrorType.Reason)entry.getKey()).getMessage()));
            }
        }
        report.info((Object)strOut.toString());
    }

    public void addInvalidIsbnReasons(Set<IsbnErrorType.Reason> reasons) {
        for (IsbnErrorType.Reason reason : reasons) {
            if (this.errorTypes.containsKey(reason)) {
                this.errorTypes.put(reason, this.errorTypes.get(reason) + 1);
                continue;
            }
            this.errorTypes.put(reason, 1);
        }
    }

    protected int getRequiredDigitsForValues(Collection<Integer> values) {
        int maxValue = 0;
        for (Integer value : values) {
            if (value <= maxValue) continue;
            maxValue = value;
        }
        return Integer.toString(maxValue).length();
    }
}

