/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.report.text;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.reports.Report;
import de.kobv.mable.reports.ReportModule;
import de.kobv.mable.reports.log4j.Log4jReportWriterFactory;
import java.io.IOException;
import java.util.List;
import org.apache.log4j.Logger;

public class TextSummaryReport
implements Report {
    private List<ReportModule> reports;
    private Logger logger;

    @Override
    public void generate() {
        Log4jReportWriterFactory reportFactory = new Log4jReportWriterFactory();
        String name = (String)MableProperties.getProperty((String)"filename");
        String logTimestamp = (String)MableProperties.getProperty((String)"timestampString");
        try {
            this.logger = reportFactory.getReportWriter(name, "report", logTimestamp, "_Mable-report.txt");
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.logger.info((Object)("Mable-Report zu MAB-Datei " + name));
        Integer datasetsFound = (Integer)MableProperties.getProperty((String)"datasetsProcessed");
        Integer datasetsIgnored = (Integer)MableProperties.getProperty((String)"datasetsIgnored");
        this.logger.info((Object)("\n" + datasetsFound + " S\u00e4tze gefunden.\n" + datasetsIgnored + " S\u00e4tze wurden ignoriert und nicht mitgez\u00e4hlt, da z.B. die Satzkennung nicht zu " + "parsen war.\n" + "Dar\u00fcber hinaus k\u00f6nnen einzelne Felder oder Unterfelder ingoriert worden sein. Siehe " + "Reject-Datei.\n"));
        for (ReportModule report : this.reports) {
            report.setReport(this.logger);
            report.generate();
        }
    }

    @Override
    public void setReport(Logger logger) {
        this.logger = logger;
    }

    public void setReports(List<ReportModule> reports) {
        this.reports = reports;
    }
}

