/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.report.html;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.mab.extension.ErrorStatistics;
import de.kobv.mable.mab.extension.ErrorType;
import de.kobv.mable.mab.extension.FieldErrorType;
import de.kobv.mable.mab2.modules.DatasetStatistics;
import de.kobv.mable.mab2.modules.FieldStatistics;
import de.kobv.mable.report.chart.PieChart;
import de.kobv.mable.report.chart.PieSlice;
import de.kobv.mable.report.util.ValueComparator;
import de.kobv.mable.reports.AbstractReport;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;

public class ReportSummary
extends AbstractReport {
    private FieldStatistics fieldStatistics;
    private DatasetStatistics datasetStatistics;
    private ErrorStatistics errorStatistics;
    private static final int INDEX_FIELD_ID = 0;
    private static final int INDEX_ERROR_COUNT = 1;
    private static final int INDEX_ERROR_CODE = 2;
    private String basePath = "de/kobv/mable/report/html/";

    @Override
    public void generate() {
        try {
            this.copyFile(this.basePath + "bvblogo.png", "bvblogo.png");
            this.copyFile(this.basePath + "kobvlogo.gif", "kobvlogo.gif");
            this.copyFile(this.basePath + "kobvlogo2.jpg", "kobvlogo2.jpg");
            this.copyFile(this.basePath + "report.css", "report.css");
            HashMap<String, String> properties = new HashMap<String, String>();
            int datasetsWithErrors = this.getDatasetsWithErrors();
            String timestampString = MableProperties.getProperty((String)"timestampString").toString();
            String filename = MableProperties.getProperty((String)"filename").toString();
            String svgFilename = filename + "_" + timestampString + "_report.svg";
            FileOutputStream out = new FileOutputStream(svgFilename);
            PieChart chart = new PieChart(220, 220);
            int datasetsTotal = (Integer)MableProperties.getProperty((String)"dataset.count");
            PieSlice slice = new PieSlice(datasetsWithErrors);
            slice.setColor("black");
            slice.setLabel(Integer.toString(datasetsWithErrors));
            chart.addSlice(slice);
            slice = new PieSlice(datasetsTotal - datasetsWithErrors);
            slice.setColor("lightgray");
            slice.setLabel(Integer.toString(datasetsTotal - datasetsWithErrors));
            chart.addSlice(slice);
            chart.renderAsSvg(out);
            ((OutputStream)out).close();
            properties.put("piefile", svgFilename);
            properties.put("timestamp", MableProperties.getProperty((String)"timestamp").toString());
            properties.put("filename.report", MableProperties.getProperty((String)"report.report").toString());
            properties.put("filename.reject", MableProperties.getProperty((String)"report.reject").toString());
            properties.put("filename.errors", MableProperties.getProperty((String)"report.errors").toString());
            properties.put("filename.nomab001", MableProperties.getProperty((String)"report.nomab001").toString());
            properties.put("filename", MableProperties.getProperty((String)"filename").toString());
            properties.put("dataset.count", MableProperties.getProperty((String)"dataset.count").toString());
            properties.put("datasetsWithErrors", Integer.toString(datasetsWithErrors));
            properties.put("datasetstatus", this.getDatasetStatusHtml());
            properties.put("datasettypes", this.getDatasetTypesHtml());
            properties.put("dataseterrors", this.getDatasetErrorsHtml());
            properties.put("fielderrors", this.getFieldErrorsHtml());
            properties.put("fieldstats", this.getFieldStatisticsHtml());
            this.copyAndFilterFile(this.basePath + "report.html", filename + "_" + timestampString + "_summary.html", properties);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public FieldStatistics getFieldStatistics() {
        return this.fieldStatistics;
    }

    public void setFieldStatistics(FieldStatistics fieldStatistics) {
        this.fieldStatistics = fieldStatistics;
    }

    protected String getDatasetErrorsHtml() throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pout = new PrintWriter(writer);
        Map result = this.errorStatistics.getFormatErrors();
        pout.println("<table id=\"datasetErrors\">");
        int index = 1;
        for (Map.Entry entry : result.entrySet()) {
            pout.println("  <tr>");
            pout.println("    <td class=\"count\">" + entry.getValue() + "</td>");
            pout.println("    <td class=\"message\">(#" + entry.getKey() + ") " + StringEscapeUtils.escapeHtml((String)((ErrorType)entry.getKey()).getMessage()) + "</td>");
            pout.println("  </tr>");
            if (index++ != 10) continue;
            break;
        }
        pout.println("</table>");
        pout.close();
        return writer.toString();
    }

    protected String getFieldErrorsHtml() throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pout = new PrintWriter(writer);
        Map result = this.errorStatistics.getFieldErrors();
        pout.println("<table id=\"fieldErrors\">");
        int index = 1;
        for (Map.Entry fehler : result.entrySet()) {
            FieldErrorType errorType = (FieldErrorType)fehler.getKey();
            pout.println("  <tr>");
            String field = errorType.getBezeichner();
            field = field.replace("' '", "_");
            pout.println("    <td class=\"field\">" + field + "</td>");
            pout.println("    <td class=\"count\">" + fehler.getValue() + "</td>");
            pout.println("    <td class=\"message\">(#" + errorType.getCode() + ") " + StringEscapeUtils.escapeHtml((String)errorType.getMessage()) + "</td>");
            pout.println("  </tr>");
            if (index++ != 10) continue;
            break;
        }
        pout.println("</table>");
        pout.close();
        return writer.toString();
    }

    protected String getDatasetStatusHtml() throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pout = new PrintWriter(writer);
        Map status = this.datasetStatistics.getStatusCount();
        pout.println("<table id=\"status\">");
        for (Map.Entry entry : status.entrySet()) {
            pout.println("  <tr>");
            pout.println("    <td>" + entry.getKey() + "</td>");
            pout.println("    <td>" + entry.getValue() + "</td");
            pout.println("  </tr>");
        }
        pout.println("</table>");
        pout.close();
        return writer.toString();
    }

    protected String getDatasetTypesHtml() throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pout = new PrintWriter(writer);
        Map types = this.datasetStatistics.getTypeCount();
        pout.println("<table id=\"status\">");
        for (Map.Entry entry : types.entrySet()) {
            pout.println("  <tr>");
            pout.println("    <td>" + entry.getKey() + "</td>");
            pout.println("    <td>" + entry.getValue() + "</td");
            pout.println("  </tr>");
        }
        pout.println("</table>");
        pout.close();
        return writer.toString();
    }

    protected String getFieldStatisticsHtml() throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter pout = new PrintWriter(writer);
        Map feldStatistik = this.fieldStatistics.getFieldCount();
        SortedSet<String> sortedFields = this.summarizeFieldStatistics();
        pout.println("<table id=\"fields\">");
        boolean index = false;
        String[] fields = sortedFields.toArray(new String[0]);
        for (int i = 0; i < 10; ++i) {
            pout.println("  <tr>");
            pout.println("    <td class=\"label\">" + fields[i] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i]) + "</td>");
            pout.println("    <td class=\"label\">" + fields[i + 10] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i + 10]) + "</td>");
            pout.println("    <td class=\"label\">" + fields[i + 20] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i + 20]) + "</td>");
            pout.println("    <td class=\"label\">" + fields[i + 30] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i + 30]) + "</td>");
            pout.println("    <td class=\"label\">" + fields[i + 40] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i + 40]) + "</td>");
            pout.println("    <td class=\"label\">" + fields[i + 50] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i + 50]) + "</td>");
            pout.println("    <td class=\"label\">" + fields[i + 60] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i + 60]) + "</td>");
            pout.println("    <td class=\"label\">" + fields[i + 70] + "</td>");
            pout.println("    <td class=\"value\">" + feldStatistik.get(fields[i + 70]) + "</td>");
            pout.println("  </tr>");
        }
        pout.println("</table>");
        writer.close();
        return writer.toString();
    }

    protected SortedSet<String> summarizeFieldStatistics() {
        Map feldStatistik = this.fieldStatistics.getFieldCount();
        ValueComparator comparator = new ValueComparator(feldStatistik);
        TreeSet<String> sortedIndex = new TreeSet<String>(comparator);
        sortedIndex.addAll(feldStatistik.keySet());
        return sortedIndex;
    }

    protected void copyFile(String source, String dest) throws IOException {
        int bytesRead;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(source);
        FileOutputStream out = new FileOutputStream(dest);
        byte[] buf = new byte[4096];
        while ((bytesRead = in.read(buf, 0, buf.length)) != -1) {
            ((OutputStream)out).write(buf, 0, bytesRead);
        }
        ((OutputStream)out).close();
        in.close();
    }

    protected void copyAndFilterFile(String source, String dest, Map<String, String> properties) throws IOException {
        int charsRead;
        InputStream in = this.getClass().getClassLoader().getResourceAsStream(source);
        InputStreamReader rin = new InputStreamReader(in);
        StringWriter wpage = new StringWriter();
        char[] cbuf = new char[4096];
        while ((charsRead = ((Reader)rin).read(cbuf, 0, cbuf.length)) != -1) {
            wpage.write(cbuf, 0, charsRead);
        }
        wpage.close();
        ((Reader)rin).close();
        String page = wpage.toString();
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            String placeholder = entry.getKey();
            String value = entry.getValue();
            Pattern pattern = Pattern.compile("\\$\\{" + placeholder + "\\}");
            Matcher matcher = pattern.matcher(page);
            page = matcher.replaceAll(value);
        }
        FileWriter out = new FileWriter(dest);
        out.write(page);
        ((Writer)out).close();
    }

    protected int getDatasetsWithErrors() throws IOException {
        String line;
        String filename = MableProperties.getProperty((String)"report.errors").toString();
        BufferedReader reader = new BufferedReader(new FileReader(filename));
        HashSet<String> datasetIds = new HashSet<String>();
        Pattern pattern = Pattern.compile("(\\w+), #\\d+");
        while ((line = reader.readLine()) != null) {
            Matcher matcher = pattern.matcher(line);
            if (!matcher.find()) continue;
            String datasetId = matcher.group(1);
            datasetIds.add(datasetId);
        }
        return datasetIds.size();
    }

    public DatasetStatistics getDatasetStatistics() {
        return this.datasetStatistics;
    }

    public void setDatasetStatistics(DatasetStatistics datasetStatistics) {
        this.datasetStatistics = datasetStatistics;
    }

    public ErrorStatistics getErrorStatistics() {
        return this.errorStatistics;
    }

    public void setErrorStatistics(ErrorStatistics errorStatistics) {
        this.errorStatistics = errorStatistics;
    }
}

