/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.report.csv;

import de.kobv.mable.common.MableProperties;
import de.kobv.mable.mab.extension.DatasetError;
import de.kobv.mable.mab.extension.ErrorLogger;
import de.kobv.mable.reports.log4j.Log4jReportWriterFactory;
import java.io.IOException;
import org.apache.log4j.Logger;

public class CsvErrorLogger
implements ErrorLogger {
    private static final Logger LOG = Logger.getLogger(CsvErrorLogger.class);
    private Logger errorLogger;

    public void logError(DatasetError error) {
        this.logError(error, null);
    }

    public void logError(DatasetError error, String message) {
        if (error == null) {
            throw new NullPointerException("logError : error is null");
        }
        this.writeError(error.getSatzId(), error.getErrorType().getCode(), message);
    }

    private void writeError(String datasetId, int errorCode, String message) {
        if (datasetId == null) {
            LOG.error((Object)("Attempting to log error (" + errorCode + ") without 001 information. "));
        }
        if (message == null) {
            this.getErrorLogger().info((Object)(datasetId + ", #" + errorCode));
        } else {
            this.getErrorLogger().info((Object)(datasetId + ", #" + errorCode + ", " + message));
        }
    }

    public Logger getErrorLogger() {
        if (this.errorLogger == null) {
            Log4jReportWriterFactory reportFactory = new Log4jReportWriterFactory();
            String name = (String)MableProperties.getProperty((String)"filename");
            String logTimestamp = (String)MableProperties.getProperty((String)"timestampString");
            try {
                this.errorLogger = reportFactory.getReportWriter(name, "errors", logTimestamp, "_Mable-errors.txt");
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.errorLogger.info((Object)("Mable-Gefundene Fehler zu MAB-Datei " + name));
            this.errorLogger.info((Object)"Datensatz-ID, Fehlercode, Weitere Informationen");
        }
        return this.errorLogger;
    }
}

