/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.report.chart;

import de.kobv.mable.report.chart.PieSlice;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class PieChart {
    private int width;
    private int height;
    private String cssClass;
    private String cssId;
    private List<PieSlice> slices = new ArrayList<PieSlice>();

    public PieChart(int width, int height) {
        this.width = width + 80;
        this.height = height;
    }

    public PieSlice createSlice(double value) {
        return null;
    }

    public void addSlice(PieSlice slice) {
        this.slices.add(slice);
    }

    public void renderAsSvg(OutputStream out) {
        PrintWriter pout = new PrintWriter(new OutputStreamWriter(out));
        pout.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" standalone=\"no\" ?>");
        pout.println("<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 20010904//EN\"");
        pout.println("\"http://www.w3.org/TR/2001/REC-SVG-20010904/DTD/svg10.dtd\">");
        pout.println("<svg width=\"" + this.width + "\" height=\"" + this.height + "\" xmlns=\"http://www.w3.org/2000/svg\" xmlns:xlink=\"http://www.w3.org/1999/xlink\">");
        pout.println("<title>Ergebnis</title>");
        pout.println("<desc>Ergebnis\u00fcbersicht</desc>");
        float total = 0.0f;
        for (PieSlice slice : this.slices) {
            total += slice.getValue();
        }
        int centerX = (this.width - 80) / 2 + 80;
        int centerY = this.height / 2;
        int radius = 100;
        double sx = centerX;
        double sy = centerY - radius;
        double totalAngle = 0.0;
        int index = 0;
        for (PieSlice slice : this.slices) {
            float value = slice.getValue();
            double angle = value / total * 360.0f;
            double angleRad = (totalAngle += angle) * 2.0 * Math.PI / 360.0;
            double dx = Math.sin(angleRad) * (double)radius;
            double dy = Math.cos(angleRad) * (double)radius;
            double x = Math.round(dx) + (long)centerX;
            double y = (long)centerY - Math.round(dy);
            String flags = angle > 180.0 ? "1,1" : "0,1";
            pout.println("<path d=\"M" + centerX + "," + centerY + " L" + Math.round(sx) + "," + Math.round(sy) + " A100,100 0 " + flags + " " + Math.round(x) + "," + Math.round(y) + " z\"");
            pout.println("style=\"fill:" + slice.getColor() + ";");
            pout.println("fill-opacity: 1;");
            pout.println("stroke: " + slice.getStroke() + ";");
            pout.println("stroke-width: 1\"/>");
            sx = x;
            sy = y;
            pout.println(String.format("<rect x=\"%1$d\" y=\"%2$d\" width=\"%3$d\" height=\"%4$d\" style=\"fill: %5$s\" />", 10, 10 + index * 20, 10, 10, slice.getColor()));
            pout.println(String.format("<text x=\"%1$d\" y=\"%2$d\" font-size=\"12pt\">%3$s</text>", 30, 20 + index * 20, slice.getLabel()));
            ++index;
        }
        pout.println("</svg>");
        pout.close();
    }
}

