/*
 * Decompiled with CFR 0.152.
 */
package de.kobv.mable.util;

import de.kobv.mable.util.ErrorReportParser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SatzfehlerStatistics
extends ErrorReportParser {
    private Map<String, Integer> errorsForDataset = new HashMap<String, Integer>();

    @Override
    public void processEntry(String satzId, String errorCode) {
        super.processEntry(satzId, errorCode);
        if (this.errorsForDataset.containsKey(satzId)) {
            int errorCount = this.errorsForDataset.get(satzId) + 1;
            this.errorsForDataset.put(satzId, errorCount);
        } else {
            this.errorsForDataset.put(satzId, 1);
        }
    }

    public Map<String, Integer> getErrorsForDataset() {
        return this.errorsForDataset;
    }

    public Map<Integer, Integer> getNumberOfDatasetsWithErrorCount() {
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        for (Map.Entry<String, Integer> entry : this.errorsForDataset.entrySet()) {
            int errorCount = entry.getValue();
            if (result.containsKey(errorCount)) {
                result.put(errorCount, (Integer)result.get(errorCount) + 1);
                continue;
            }
            result.put(errorCount, 1);
        }
        return result;
    }

    public Set<String> getDatasetsWithErrorCount(int errorCount) {
        HashSet<String> saetze = new HashSet<String>();
        for (Map.Entry<String, Integer> entry : this.errorsForDataset.entrySet()) {
            if (entry.getValue() != errorCount) continue;
            saetze.add(entry.getKey());
        }
        return saetze;
    }
}

